/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class PzExpressionParser {
    private static Evaluator evaluator;

    private static Evaluator getEvaluator() {
        if (evaluator == null) {
            evaluator = new Evaluator();
            PzExpressionParser.addCustomFunctions(evaluator);
        }
        return evaluator;
    }

    public static String getString(String expression) throws PzExpressionParserException {
        try {
            return PzExpressionParser.getEvaluator().evaluate(expression);
        }
        catch (EvaluationException e) {
            throw new PzExpressionParserException((Exception)((Object)e));
        }
    }

    public static Double getDouble(String expression) throws PzExpressionParserException {
        try {
            return PzExpressionParser.getEvaluator().getNumberResult(expression);
        }
        catch (EvaluationException e) {
            throw new PzExpressionParserException((Exception)((Object)e));
        }
    }

    public static Boolean getBoolean(String expression) throws PzExpressionParserException {
        try {
            return PzExpressionParser.getEvaluator().getBooleanResult(expression);
        }
        catch (EvaluationException e) {
            throw new PzExpressionParserException((Exception)((Object)e));
        }
    }

    private static void addCustomFunctions(Evaluator eval) {
        eval.putFunction((Function)new Round());
        eval.putFunction((Function)new Sum());
        eval.putFunction((Function)new DateFormat());
    }

    public static class DateFormat
    implements Function {
        public FunctionResult execute(Evaluator arg0, String arguments) throws FunctionException {
            String result = null;
            String exceptionMessage = "One string argument is required.";
            ArrayList strings = FunctionHelper.getStrings((String)arguments, (char)',');
            if (strings.size() != 1) {
                throw new FunctionException(exceptionMessage);
            }
            try {
                String arg = FunctionHelper.trimAndRemoveQuoteChars((String)((String)strings.get(0)), (char)evaluator.getQuoteCharacter());
                result = new SimpleDateFormat("dd.MM.yyyy").format(new SimpleDateFormat("yyyy-MM-dd").parse(arg));
            }
            catch (FunctionException fe) {
                throw new FunctionException(fe.getMessage(), (Exception)((Object)fe));
            }
            catch (Exception e) {
                throw new FunctionException(exceptionMessage, e);
            }
            return new FunctionResult(result, 1);
        }

        public String getName() {
            return "dateFormat";
        }
    }

    public static class PzExpressionParserException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PzExpressionParserException() {
        }

        public PzExpressionParserException(Exception e) {
            super(e);
        }

        public PzExpressionParserException(String message) {
            super(message);
        }

        public PzExpressionParserException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class Round
    implements Function {
        public String getName() {
            return "cround";
        }

        public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
            Double result = null;
            Double number = null;
            try {
                number = new Double(arguments);
            }
            catch (Exception e) {
                throw new FunctionException("Invalid argument.", e);
            }
            result = new BigDecimal(number).setScale(2, 4).doubleValue();
            return new FunctionResult(result.toString(), 0);
        }
    }

    public static class Sum
    implements Function {
        public String getName() {
            return "sum";
        }

        public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
            double result = 0.0;
            ArrayList numbers = FunctionHelper.getDoubles((String)arguments, (char)',');
            for (Double number : numbers) {
                result += number.doubleValue();
            }
            return new FunctionResult(String.valueOf(result), 0);
        }
    }
}

