/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Komitentgrupa;
import rs.pezar.sifarnici.gui.grupeKomitenata.Dodavanje;
import rs.pezar.sifarnici.gui.grupeKomitenata.SadrzajGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogKorisnickeGrupe
extends PzDialog {
    private static final String GRUPA_KOMERCIJALISTA = "komercijalistiGrupa";
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzToolBarIcon icnNovaGrupa;
    private PzToolBarIcon icnIzmenaGrupe;
    private PzToolBarIcon icnBrisanjeGrupe;
    private PzTable tblGrupe;
    private JScrollPane scrollPane;
    private PzToolBarIcon icnSadrzajGrupe;
    private final String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brStavki = new JLabel();

    public PzDialogKorisnickeGrupe(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        EntityManager em = PzEntityManager.getEm();
        List data = null;
        String user = PzApplication.getApplication().getSession().getLoggedUser().getPzusername();
        String upit = "";
        upit = PzParameter.getParameterValue((String)"GRP_KOMITENT_VIDLJIVOST", (String)"sve", (EntityManager)em).equals("sve") ? "SELECT g FROM Komitentgrupa g Where %tip%" : "SELECT g FROM Komitentgrupa g Where %tip% and g.pzuser.pzusername ='" + user + "'";
        upit = this.parameter.equals(GRUPA_KOMERCIJALISTA) ? upit.replace("%tip%", "g.tip = 'KOMERC'") : upit.replace("%tip%", "g.tip is null ");
        data = em.createQuery(upit).getResultList();
        this.tblGrupe.setData(data, Komitentgrupa.class);
        this.brStavki.setText(Integer.toString(data.size()));
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            if (this.parameter.equals(GRUPA_KOMERCIJALISTA)) {
                this.setTitle("Grupe komercijalista");
            } else {
                this.setTitle("Korisni\u010dke grupe");
            }
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.BLUE, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{101, 7, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnNovaGrupa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNovaGrupa);
            this.icnNovaGrupa.setText("Dodavanje|(INS)");
            this.icnNovaGrupa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessmen_new.png")));
            this.icnNovaGrupa.setActionCommand("dodaj");
            this.icnNovaGrupa.addActionListener((ActionListener)((Object)this));
            this.icnNovaGrupa.setShortcut("INSERT");
            this.icnIzmenaGrupe = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmenaGrupe);
            this.icnIzmenaGrupe.setText("Izmena|(F3)");
            this.icnIzmenaGrupe.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessmen_edit.png")));
            this.icnIzmenaGrupe.setActionCommand("izmena");
            this.icnIzmenaGrupe.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaGrupe.setShortcut("f3");
            this.icnBrisanjeGrupe = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanjeGrupe);
            this.icnBrisanjeGrupe.setText("Brisanje|(DELETE)");
            this.icnBrisanjeGrupe.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessmen_delete.png")));
            this.icnBrisanjeGrupe.setActionCommand("brisi");
            this.icnBrisanjeGrupe.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeGrupe.setShortcut("DELETE");
            this.icnSadrzajGrupe = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSadrzajGrupe);
            this.icnSadrzajGrupe.setText("Sadr\u017eaj|(F2)");
            this.icnSadrzajGrupe.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessmen_view.png")));
            this.icnSadrzajGrupe.setActionCommand("sadrzaj");
            this.icnSadrzajGrupe.addActionListener((ActionListener)((Object)this));
            this.icnSadrzajGrupe.setShortcut("f2");
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tblGrupe = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblGrupe);
            this.tblGrupe.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Komitentgrupa grupa = (Komitentgrupa)entity;
                    if (grupa.getTip() != null && grupa.getTip().equals("KOMERC")) {
                        return new Object[]{grupa.getIdKomitentGrupa(), grupa.getNaziv(), grupa.getProvizija(), grupa.getPzuser().getPzusername()};
                    }
                    return new Object[]{grupa.getIdKomitentGrupa(), grupa.getNaziv(), grupa.getPzuser().getPzusername()};
                }

                public String[] getColumnNames() {
                    if (PzDialogKorisnickeGrupe.this.parameter.equals(PzDialogKorisnickeGrupe.GRUPA_KOMERCIJALISTA)) {
                        return new String[]{"Oznaka", "Naziv", "Provizija", "Korisnik"};
                    }
                    return new String[]{"Oznaka", "Naziv", "Korisnik"};
                }
            });
            this.tblGrupe.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PzDialogKorisnickeGrupe.this.tblGrupe.getSelectedRow() == -1) {
                        return;
                    }
                    PzDialogKorisnickeGrupe.this.getSession().putParameter("grupa", (Object)PzDialogKorisnickeGrupe.this.tblGrupe.getSelectedEntity());
                    PzDialogKorisnickeGrupe.this.showDialog(SadrzajGrupe.class);
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj grupa");
            this.statusBar.add((Component)this.brStavki);
            this.brStavki.setFocusable(false);
            this.brStavki.setOpaque(false);
            this.setSize(537, 410);
            this.setMinimumSize(new Dimension(537, 410));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.getSession().putParameter("tabela", (Object)this.tblGrupe);
                this.getSession().putParameter("parameter", (Object)this.parameter);
                if (actionCommand.equals("dodaj")) {
                    this.getSession().putParameter("update", (Object)false);
                    this.showDialog(Dodavanje.class);
                } else if (actionCommand.equals("izmena")) {
                    if (this.tblGrupe.getSelectedRow() != -1) {
                        this.getSession().putParameter("update", (Object)true);
                        this.showDialog(Dodavanje.class);
                    }
                } else if (actionCommand.equals("brisi")) {
                    if (this.tblGrupe.getSelectedRow() != -1) {
                        em.getTransaction().begin();
                        this.tblGrupe.removeSelectedEntity(true, em);
                        em.getTransaction().commit();
                        this.tblGrupe.commitRemove();
                    }
                } else if (actionCommand.equals("sadrzaj") && this.tblGrupe.getSelectedRow() != -1) {
                    this.getSession().putParameter("grupa", (Object)this.tblGrupe.getSelectedEntity());
                    this.showDialog(SadrzajGrupe.class);
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

