/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dozvola;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.sifarnici.gui.PzDialogRjNew;
import rs.pezar.sifarnici.gui.radneJedinice.DodavanjeRj;
import rs.pezar.sifarnici.gui.radneJedinice.IzborRj;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogRJ
extends PzDialog {
    private static final long serialVersionUID = -5877640636102701875L;
    private final PzPanel contentPanel = new PzPanel();
    private PzToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzPanel pnlTable;
    private JScrollPane scp;
    private PzTable table;
    private PzStatusBar statusbar;
    private List<Radnajedinica> radnejedinice;
    private static Radnajedinica rj;

    public static void main(String[] args) {
        try {
            PzDialogRjNew dialog = new PzDialogRjNew();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogRJ() {
        this.initGUI();
    }

    public PzDialogRJ(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogRJ(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public PzDialogRJ(PzDialog parent, List<Radnajedinica> radnejedinice) {
        this.radnejedinice = radnejedinice;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("\u0160ifarnik radnih jedinica");
            this.setBounds(100, 100, 450, 300);
            this.getContentPane().setLayout(new BorderLayout());
            this.contentPanel.setLayout((LayoutManager)new BorderLayout());
            this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.toolbar = new PzToolBar();
            this.toolbar.setFloatable(false);
            this.contentPanel.add((Component)this.toolbar, (Object)"North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|radne jedinice|(Insert)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/factory_add.png")));
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|radne jedinice|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/factory_edit.png")));
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnIzmena.setActionCommand("izmena");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|radne jedinice|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/factory_delete.png")));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.pnlTable = new PzPanel();
            this.contentPanel.add((Component)this.pnlTable, (Object)"Center");
            GridBagLayout gbl_pnlTable = new GridBagLayout();
            gbl_pnlTable.columnWidths = new int[2];
            gbl_pnlTable.rowHeights = new int[2];
            gbl_pnlTable.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pnlTable.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.pnlTable.setLayout((LayoutManager)gbl_pnlTable);
            this.scp = new JScrollPane();
            GridBagConstraints gbc_scp = new GridBagConstraints();
            gbc_scp.fill = 1;
            gbc_scp.gridx = 0;
            gbc_scp.gridy = 0;
            this.pnlTable.add((Component)this.scp, (Object)gbc_scp);
            this.table = this.radnejedinice != null ? new PzTable(this.radnejedinice, Radnajedinica.class) : new PzTable(PzEntityManager.getList((String)"SELECT r FROM Radnajedinica r ORDER BY r.grupaMagacina"), Radnajedinica.class);
            this.table.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = -763678948880734361L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    rj = (Radnajedinica)PzDialogRJ.this.table.getSelectedEntity();
                    PzDialogRJ.this.dispose();
                }
            });
            this.scp.setViewportView((Component)this.table);
            this.statusbar = new PzStatusBar();
            this.contentPanel.add((Component)this.statusbar, (Object)"South");
            this.setSize(600, 700);
            this.setMinimumSize(new Dimension(500, 365));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Radnajedinica getRj(PzDialog parent, List<Radnajedinica> radnejedinice) {
        PzDialogRJ dlg = new PzDialogRJ(parent, radnejedinice);
        dlg.setParentDialog(parent);
        parent.setChildDialog((PzDialog)dlg);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.restoreSize();
        dlg.setVisible(true);
        Radnajedinica tmp = rj;
        rj = null;
        parent.setChildDialog(null);
        return tmp;
    }

    public static Radnajedinica getRJ(PzDialog parent) {
        return PzDialogRJ.getRJ(parent, null);
    }

    public static Radnajedinica getRJ(PzDialog parent, String title) {
        Radnajedinica result = null;
        try {
            List radnejedinice = PzEntityManager.getList((String)"SELECT r FROM Radnajedinica r ORDER BY r.grupaMagacina");
            PzDialogRJ.filterRj(radnejedinice);
            result = radnejedinice.size() == 1 ? (Radnajedinica)radnejedinice.get(0) : IzborRj.getRj(parent, radnejedinice, title);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
        return result;
    }

    public static Radnajedinica getRJ(PzDialog parent, String[] tipovi) {
        return PzDialogRJ.getRJ(parent, tipovi, null);
    }

    public static Radnajedinica getRJ(PzDialog parent, String[] tipovi, String title) {
        Radnajedinica result = null;
        try {
            List radnejedinice = PzEntityManager.getList((String)"SELECT r FROM Radnajedinica r ORDER BY r.grupaMagacina");
            PzDialogRJ.filterRj(radnejedinice);
            Vector<Radnajedinica> tmp = new Vector<Radnajedinica>();
            block2: for (Radnajedinica rj : radnejedinice) {
                int i = 0;
                while (i < tipovi.length) {
                    if (rj.getTip().equals(tipovi[i])) {
                        tmp.add(rj);
                        continue block2;
                    }
                    ++i;
                }
            }
            result = tmp.size() == 1 ? (Radnajedinica)tmp.get(0) : IzborRj.getRj(parent, tmp, title);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
        return result;
    }

    public static Radnajedinica getRJ(PzDialog parent, Character ... gTipovi) {
        return PzDialogRJ.getRJ(parent, null, gTipovi);
    }

    public static Radnajedinica getRJ(PzDialog parent, String title, Character ... gTipovi) {
        Radnajedinica result = null;
        String list = "";
        int i = 0;
        while (i < gTipovi.length) {
            list = String.valueOf(list) + (i == 0 ? "" : ",") + "'" + gTipovi[i] + "'";
            ++i;
        }
        String query = "SELECT r FROM Radnajedinica r WHERE r.gTip IN (" + list + ") ORDER BY r.grupaMagacina";
        try {
            List radnejedinice = PzEntityManager.getList((String)query);
            PzDialogRJ.filterRj(radnejedinice);
            result = radnejedinice.size() == 1 ? (Radnajedinica)radnejedinice.get(0) : IzborRj.getRj(parent, radnejedinice, title);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
        return result;
    }

    public static Radnajedinica getRJExcluding(PzDialog parent, Character ... tipovi) {
        Radnajedinica result = null;
        String list = "";
        int i = 0;
        while (i < tipovi.length) {
            list = String.valueOf(list) + (i == 0 ? "" : ",") + "'" + tipovi[i] + "'";
            ++i;
        }
        String query = "SELECT r FROM Radnajedinica r WHERE r.gTip NOT IN (" + list + ") ORDER BY r.grupaMagacina";
        try {
            List radnejedinice = PzEntityManager.getList((String)query);
            PzDialogRJ.filterRj(radnejedinice);
            result = radnejedinice.size() == 1 ? (Radnajedinica)radnejedinice.get(0) : IzborRj.getRj(parent, radnejedinice);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
        return result;
    }

    public static Radnajedinica getRJExcluding(PzDialog parent, String ... tipovi) {
        Radnajedinica result = null;
        try {
            List radnejedinice = PzEntityManager.getList((String)"SELECT r FROM Radnajedinica r ORDER BY r.grupaMagacina");
            PzDialogRJ.filterRj(radnejedinice);
            Vector<Radnajedinica> tmp = new Vector<Radnajedinica>();
            block2: for (Radnajedinica rj : radnejedinice) {
                int i = 0;
                while (i < tipovi.length) {
                    if (!rj.getTip().equals(tipovi[i])) {
                        tmp.add(rj);
                        continue block2;
                    }
                    ++i;
                }
            }
            result = tmp.size() == 1 ? (Radnajedinica)tmp.get(0) : IzborRj.getRj(parent, tmp);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
        return result;
    }

    public static Radnajedinica getRJUnlimited(PzDialog parent) {
        Radnajedinica result = null;
        try {
            List radnejedinice = PzEntityManager.getList((String)"SELECT r FROM Radnajedinica r ORDER BY r.grupaMagacina");
            result = radnejedinice.size() == 1 ? (Radnajedinica)radnejedinice.get(0) : IzborRj.getRj(parent, radnejedinice, "Izaberite radnu jedinicu");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
        return result;
    }

    private static void filterRj(List<Radnajedinica> radnejedinice) {
        if (!PzApplication.getApplication().getSession().getLoggedUser().isKorisnik()) {
            return;
        }
        List dozvole = PzApplication.getApplication().getSession().getLoggedUser().getDozvole("RJ");
        Iterator<Radnajedinica> iterator = radnejedinice.iterator();
        while (iterator.hasNext()) {
            Radnajedinica rj = iterator.next();
            boolean found = false;
            for (Dozvola d : dozvole) {
                if (!d.getId().getOpcija().equals(rj.getId().getOznRj())) continue;
                found = true;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public static List<Radnajedinica> getAvaliableRj() {
        try {
            List radnejedinice = PzEntityManager.getList((String)"SELECT r FROM Radnajedinica r ORDER BY r.grupaMagacina");
            PzDialogRJ.filterRj(radnejedinice);
            return radnejedinice;
        }
        catch (Exception e) {
            PzLogger.getInstance().logException((Throwable)e);
            return null;
        }
    }

    public static String getAvaliableRjString() {
        List<Radnajedinica> radnejedinice = PzDialogRJ.getAvaliableRj();
        String res = "";
        if (radnejedinice == null || radnejedinice.size() == 0) {
            return res;
        }
        int i = 0;
        while (i < radnejedinice.size()) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + "'" + radnejedinice.get(i).getId().getOznRj() + "'";
            ++i;
        }
        return res;
    }

    public static List<RadnajedinicaPK> getAvaliableRjId() {
        List<Radnajedinica> radnejedinice = PzDialogRJ.getAvaliableRj();
        Vector<RadnajedinicaPK> ids = new Vector<RadnajedinicaPK>();
        if (radnejedinice == null || radnejedinice.size() == 0) {
            return ids;
        }
        int i = 0;
        while (i < radnejedinice.size()) {
            ids.add(radnejedinice.get(i).getId());
            ++i;
        }
        return ids;
    }

    public void actionPerformed(ActionEvent e) {
        String action = ((PzToolBarIcon)e.getSource()).getActionCommand();
        if (action.equals("dodavanje")) {
            this.getSession().putParameter("table", (Object)this.table);
            this.getSession().putParameter("update", (Object)Boolean.FALSE);
            this.showDialog(DodavanjeRj.class);
        } else if (action.equals("izmena")) {
            this.getSession().putParameter("table", (Object)this.table);
            this.getSession().putParameter("update", (Object)Boolean.TRUE);
            this.showDialog(DodavanjeRj.class);
        } else if (action.equals("brisanje")) {
            this.table.removeSelectedEntity(true, true);
        }
    }
}

