/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.OEBroj;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class BrowserOemPanel
extends BrowserComponent {
    private static final long serialVersionUID = 8356503884566804877L;
    public static final String ID = "PANEL_OEM";
    private JScrollPane scp;
    private PzTable table;
    private PzBusyPainterUI layerUI;
    private JXLayer<JScrollPane> layer;

    public BrowserOemPanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(1, 3, 1, 1));
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.scp = new JScrollPane();
        this.layerUI = new PzBusyPainterUI();
        this.layer = new JXLayer((Component)this.scp, (LayerUI)this.layerUI);
        this.add((Component)this.layer);
        this.table = new PzTable();
        this.scp.setViewportView((Component)this.table);
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
        if (a == null) {
            return;
        }
        this.table.setData(a.getOebrojs(), OEBroj.class);
    }

    @Override
    public void updateData(final Stanjeartikal a, Object parentComponent) {
        if (a == null) {
            return;
        }
        this.layerUI.setLocked(true);
        SwingWorker<List<OEBroj>, Object> worker = new SwingWorker<List<OEBroj>, Object>(){

            @Override
            protected List<OEBroj> doInBackground() throws Exception {
                String query = "SELECT o FROM OEBroj o WHERE o.id.sfrProizvod = '" + a.getId().getSfrProizvod() + "'";
                return PzEntityManager.getList((String)query);
            }

            @Override
            protected void done() {
                try {
                    BrowserOemPanel.this.layerUI.setLocked(false);
                    BrowserOemPanel.this.table.setData((List)this.get(), OEBroj.class);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)BrowserOemPanel.this), (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    @Override
    public void focusGained() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "OE brojevi";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public PzToolBarIcon getSwitchIcon() {
        PzToolBarIcon icnOEM = new PzToolBarIcon();
        icnOEM.setText("OE|brojevi|(ALT+F10)");
        icnOEM.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_oem.png")));
        icnOEM.addActionListener(this.createSwitchActionListener());
        icnOEM.setActionCommand("oem");
        icnOEM.setShortcut("ALT+F10");
        return icnOEM;
    }
}

