/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.grupeKomitenata;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Komitentgrupa;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;

public class Dodavanje
extends PzDialogInsert {
    private static final String GRUPA_KOMERCIJALISTA = "komercijalistiGrupa";
    private PzPanel pnlGlavni;
    private PzTextField tfNaziv;
    private PzButton btnPotvrdi;
    private PzPanelHeader header;
    private JLabel lblNaziv;
    private PzTable tblTabela;
    private Komitentgrupa grupa;
    private PzDoubleField dfProcenat;
    private JLabel lblProcenat;
    private String parameter;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equals(GRUPA_KOMERCIJALISTA)) {
            this.lblNaziv.setText("Naziv komercijaliste");
        } else {
            this.lblNaziv.setText("Naziv grupe komitenata");
            this.lblProcenat.setEnabled(false);
            this.dfProcenat.setEnabled(false);
            this.dfProcenat.setFocusable(false);
        }
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.LIGHT_GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{78, 32, 25, 15, 32, 20, 20};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{20, 131, 265, 7, 20};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(628, 301));
            this.lblNaziv = new JLabel();
            this.pnlGlavni.add((Component)this.lblNaziv, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv = new PzTextField();
            this.pnlGlavni.add((Component)this.tfNaziv, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.pnlGlavni.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setPreferredSize(new Dimension(140, 31));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.lblProcenat = new JLabel();
            this.pnlGlavni.add((Component)this.lblProcenat, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblProcenat.setName("lblProcenat");
            this.dfProcenat = new PzDoubleField();
            this.pnlGlavni.add((Component)this.dfProcenat, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 125), 0, 0));
            this.setPreferredSize(new Dimension(500, 299));
            this.setResizable(false);
            this.pack();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("insert")) {
                    em.getTransaction().begin();
                    Komitentgrupa grupa = new Komitentgrupa();
                    Integer broj = (Integer)em.createQuery("SELECT MAX(g.idKomitentGrupa) FROM Komitentgrupa g ").getSingleResult();
                    broj = broj == null ? Integer.valueOf(1) : Integer.valueOf(broj + 1);
                    grupa.setIdKomitentGrupa(broj);
                    grupa.setNaziv(this.tfNaziv.getVal());
                    grupa.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
                    if (this.parameter.equals(GRUPA_KOMERCIJALISTA)) {
                        grupa.setTip("KOMERC");
                        grupa.setProvizija(this.dfProcenat.getVal());
                    }
                    this.tblTabela.insert((PzEntity)grupa, em);
                    em.getTransaction().commit();
                    this.tblTabela.commitInsert();
                } else if (actionCommand.equals("update")) {
                    em.getTransaction().begin();
                    this.grupa.setNaziv(this.tfNaziv.getVal());
                    if (this.parameter.equals(GRUPA_KOMERCIJALISTA)) {
                        this.grupa.setProvizija(this.dfProcenat.getVal());
                    }
                    this.tblTabela.updateSelectedEntity((PzEntity)this.grupa, em);
                    em.getTransaction().commit();
                    this.tblTabela.commitUpdate();
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
        this.parameter = (String)this.getSession().getParameter("parameter");
        this.tblTabela = (PzTable)this.getSession().getParameter("tabela");
        this.btnPotvrdi.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.parameter = (String)this.getSession().getParameter("parameter");
        this.tblTabela = (PzTable)this.getSession().getParameter("tabela");
        this.btnPotvrdi.setActionCommand("update");
        this.grupa = (Komitentgrupa)this.tblTabela.getSelectedEntity();
        this.tfNaziv.setVal((Object)this.grupa.getNaziv());
        if (this.parameter.equals(GRUPA_KOMERCIJALISTA)) {
            this.dfProcenat.setVal((Object)this.grupa.getProvizija());
        }
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessmen_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessmen_edit.png")));
    }

    public boolean shouldBeShown() {
        this.parameter = (String)this.getSession().getParameter("parameter");
        return true;
    }
}

