/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.komintenti;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.KomitentparameterPK;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;

public class Garancije
extends PzDialog {
    private static final long serialVersionUID = -3362895422040638148L;
    private static String MENICA = "MENICA";
    private static String VREDNOST_MENICE = "VREDNOST_M";
    private static String OVLASCENJE = "OVLASCENJE";
    private static String UGOVOR_SA_BANKOM = "UGOVOR";
    private static String BROJ_UGOVORA_O_PRODAJI = "BROJ_UGOVORA";
    private static String DEPO_KARTON = "DEPO";
    private static String NAPOMENA = "GARANCIJA_NAPOMENA";
    private PzPanel panel;
    private PzTextAreaPanel areaNapomena;
    private JLabel lblKupac;
    private PzTextField tfKupac;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private PzNumericOnlyTextField menica;
    private PzNumericOnlyTextField ovlascenje;
    private PzTextField ugovor;
    private PzTextField brojUgovora;
    private PzDoubleField vrednost;
    private JCheckBox depoKarton;
    private PzPanelHeader header;
    private Komitent komitent;
    private Komitentparameter pM = null;
    private Komitentparameter pV = null;
    private Komitentparameter pO = null;
    private Komitentparameter pU = null;
    private Komitentparameter pB = null;
    private Komitentparameter pD = null;
    private Komitentparameter pN = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Garancije inst = new Garancije(frame);
                inst.setVisible(true);
            }
        });
    }

    public Garancije(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Garancije(PzDialog dialog) {
        super(dialog);
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        this.pM = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), MENICA));
        if (this.pM != null) {
            this.menica.setVal((Object)this.pM.getValue());
        }
        this.pV = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), VREDNOST_MENICE));
        if (this.pV != null) {
            this.vrednost.setVal((Object)new Double(this.pV.getValue()));
        }
        this.pO = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), OVLASCENJE));
        if (this.pO != null) {
            this.ovlascenje.setVal((Object)this.pO.getValue());
        }
        this.pU = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), UGOVOR_SA_BANKOM));
        if (this.pU != null) {
            this.ugovor.setVal((Object)this.pU.getValue());
        }
        this.pB = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), BROJ_UGOVORA_O_PRODAJI));
        if (this.pB != null) {
            this.brojUgovora.setVal((Object)this.pB.getValue());
        }
        this.pD = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), DEPO_KARTON));
        if (this.pD != null && this.pD.getValue().equals("DA")) {
            this.depoKarton.setSelected(true);
        }
        this.pN = (Komitentparameter)PzEntityManager.getEm().find(Komitentparameter.class, (Object)new KomitentparameterPK(this.komitent.getSfrKomitent(), NAPOMENA));
        if (this.pN != null) {
            this.areaNapomena.setVal((Object)this.pN.getValue());
        }
    }

    private void initGUI() {
        try {
            this.setResizable(false);
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelLayout.rowHeights = new int[]{25, 25, 25, 25, 25, 25, 73, 25, 20};
            panelLayout.columnWeights = new double[]{0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            int[] nArray = new int[8];
            nArray[0] = 20;
            nArray[1] = 242;
            nArray[2] = 72;
            nArray[3] = 175;
            nArray[5] = 120;
            nArray[6] = 8;
            nArray[7] = 7;
            panelLayout.columnWidths = nArray;
            this.panel.setLayout((LayoutManager)panelLayout);
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(444, 55));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(58, 9, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.setActionCommand("ok");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Menica");
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Vrednost menice");
            this.jLabel4 = new JLabel();
            this.panel.add((Component)this.jLabel4, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setText("Ovlascenje");
            this.jLabel5 = new JLabel();
            this.panel.add((Component)this.jLabel5, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel5.setText("Ugovor o pristupanju duga");
            this.jLabel6 = new JLabel();
            this.panel.add((Component)this.jLabel6, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel6.setText("Ugovor o prodaji");
            this.menica = new PzNumericOnlyTextField();
            this.panel.add((Component)this.menica, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.menica.setFont(new Font("Tahoma", 0, 14));
            this.menica.setMaxLength(3);
            this.vrednost = new PzDoubleField();
            this.panel.add((Component)this.vrednost, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.vrednost.setFont(new Font("Tahoma", 0, 14));
            this.vrednost.setLimit(12, 2);
            this.ovlascenje = new PzNumericOnlyTextField();
            this.panel.add((Component)this.ovlascenje, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.ovlascenje.setFont(new Font("Tahoma", 0, 14));
            this.ovlascenje.setMaxLength(3);
            this.ugovor = new PzTextField();
            this.panel.add((Component)this.ugovor, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.ugovor.setFont(new Font("Tahoma", 0, 14));
            this.ugovor.setMaxLength(50);
            this.brojUgovora = new PzTextField();
            this.panel.add((Component)this.brojUgovora, (Object)new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.brojUgovora.setFont(new Font("Tahoma", 0, 14));
            this.brojUgovora.setMaxLength(30);
            this.depoKarton = new JCheckBox();
            this.panel.add((Component)this.depoKarton, (Object)new GridBagConstraints(2, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.depoKarton.setText("Ostavljen depo karton");
            this.depoKarton.setFont(new Font("Tahoma", 0, 12));
            this.lblKupac = new JLabel();
            this.panel.add((Component)this.lblKupac, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblKupac.setText("Kupac");
            this.tfKupac = new PzTextField();
            this.panel.add((Component)this.tfKupac, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfKupac.setVal((Object)("[ " + this.komitent.getSfrKomitent() + " ] " + this.komitent.getNaziv()));
            this.tfKupac.setFocusable(false);
            this.tfKupac.setEnabled(false);
            this.tfKupac.setFont(new Font("Tahoma", 1, 11));
            this.areaNapomena = new PzTextAreaPanel();
            this.panel.add((Component)this.areaNapomena, (Object)new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.areaNapomena.setBorder((Border)BorderFactory.createTitledBorder("Napomena"));
            this.header = new PzPanelHeader();
            ImageIcon headerIcon = new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/building_new.png"));
            this.header.setIcon(headerIcon);
            this.header.setTitle("Garancije placanja kupca");
            this.getContentPane().add((Component)this.header, "North");
            this.setSize(476, 425);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equalsIgnoreCase("ok")) {
            try {
                try {
                    Komitentparameter p;
                    em.getTransaction().begin();
                    if (this.pM == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), MENICA));
                        p.setValue(this.menica.getVal());
                        em.persist((Object)p);
                    } else {
                        this.pM.setValue(this.menica.getVal());
                        em.merge((Object)this.pM);
                    }
                    if (this.pV == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), VREDNOST_MENICE));
                        p.setValue(this.vrednost.getVal().toString());
                        em.persist((Object)p);
                    } else {
                        this.pV.setValue(this.vrednost.getVal().toString());
                        em.merge((Object)this.pV);
                    }
                    if (this.pO == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), OVLASCENJE));
                        p.setValue(this.ovlascenje.getVal());
                        em.persist((Object)p);
                    } else {
                        this.pO.setValue(this.ovlascenje.getVal());
                        em.merge((Object)this.pO);
                    }
                    if (this.pU == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), UGOVOR_SA_BANKOM));
                        p.setValue(this.ugovor.getVal());
                        em.persist((Object)p);
                    } else {
                        this.pU.setValue(this.ugovor.getVal());
                        em.merge((Object)this.pU);
                    }
                    if (this.pB == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), BROJ_UGOVORA_O_PRODAJI));
                        p.setValue(this.brojUgovora.getVal());
                        em.persist((Object)p);
                    } else {
                        this.pB.setValue(this.brojUgovora.getVal());
                        em.merge((Object)this.pB);
                    }
                    if (this.pN == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), NAPOMENA));
                        p.setValue(this.areaNapomena.getVal());
                        em.persist((Object)p);
                    } else {
                        this.pN.setValue(this.areaNapomena.getVal());
                        em.merge((Object)this.pN);
                    }
                    if (this.pD == null) {
                        p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), DEPO_KARTON));
                        if (this.depoKarton.isSelected()) {
                            p.setValue("DA");
                        } else {
                            p.setValue("NE");
                        }
                        em.persist((Object)p);
                    } else {
                        if (this.depoKarton.isSelected()) {
                            this.pD.setValue("DA");
                        } else {
                            this.pD.setValue("NE");
                        }
                        em.merge((Object)this.pD);
                    }
                    em.getTransaction().commit();
                    this.dispose();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
    }
}

