/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.komintenti.tekuciRacuniKomintenta;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzNumericOnlyTextField kbr;
    private PzNumericOnlyTextField partija;
    private PzNumericOnlyTextField kod;
    private PzFieldIndikator indBanka;
    private PzTextField banka;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
        this.setData2(data2);
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(435, 102));
            panelLayout.rowWeights = new double[]{0.0, 0.0};
            panelLayout.rowHeights = new int[]{25, 25};
            panelLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.0, 0.1, 0.1};
            panelLayout.columnWidths = new int[]{86, 7, 130, 42, 20, 20};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Teku\u0107i ra\u010dun");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Banka");
            this.banka = new PzTextField();
            this.panel.add((Component)this.banka, (Object)new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.banka.setFont(new Font("Tahoma", 0, 14));
            this.banka.setMaxLength(100);
            this.banka.setSize(80, 24);
            this.banka.setVerifyInput(true);
            this.indBanka = new PzFieldIndikator();
            this.panel.add((Component)this.indBanka, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.kod = new PzNumericOnlyTextField();
            this.kod.setMaxLength(3);
            this.kod.setVerifyInput(true);
            this.panel.add((Component)this.kod, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.partija = new PzNumericOnlyTextField();
            this.partija.setMaxLength(13);
            this.partija.setVerifyInput(true);
            this.panel.add((Component)this.partija, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.kbr = new PzNumericOnlyTextField();
            this.kbr.setMaxLength(2);
            this.kbr.setVerifyInput(true);
            this.panel.add((Component)this.kbr, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(435, 55));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(48, 9, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.banka.setStateIndikator(this.indBanka);
            this.setSize(441, 262);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equalsIgnoreCase("odustajanje")) {
                this.dispose();
            } else if (actionCommand.equals("insert")) {
                Komitent komitent = (Komitent)this.getSession().getParameter("komitent");
                String partijaStr = this.partija.getVal();
                String tekuciRacunStr = String.valueOf(this.kod.getVal()) + "-" + partijaStr + "-" + PzEntityUtil.strZero((String)this.kbr.getVal(), (int)2);
                Tekuciracun tRacun = new Tekuciracun(tekuciRacunStr, this.banka.getVal(), komitent);
                this.getTable().insert((PzEntity)tRacun, false);
                PzEntityManager.update((Object)komitent);
            } else if (actionCommand.equals("update")) {
                Tekuciracun racun = (Tekuciracun)this.getTable().getSelectedEntity();
                racun.setBanka(this.banka.getVal());
                this.getTable().updateSelectedEntity((PzEntity)racun, true);
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        Tekuciracun racun = (Tekuciracun)this.getTable().getSelectedEntity();
        String br = racun.getBrRacuna();
        String kod1 = br.split("\\-")[0];
        String partija1 = br.split("\\-")[1];
        String kbr1 = br.split("\\-")[2];
        this.kod.setVal((Object)kod1);
        this.kod.setEnabled(false);
        this.partija.setVal((Object)partija1);
        this.partija.setEnabled(false);
        this.kbr.setVal((Object)kbr1);
        this.kbr.setEnabled(false);
        this.banka.setVal((Object)racun.getBanka());
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje teku\u0107eg ra\u010duna");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/creditcards_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena teku\u0107eg ra\u010duna");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/creditcards_edit.png")));
    }

    private KeyListener getKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '-') {
                    e.getComponent().transferFocus();
                }
            }
        };
    }
}

