/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.kontniPlan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.apache.commons.beanutils.BeanUtils;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.globals.TipAnalitika;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzFieldIndikator indNaziv;
    private PzFieldIndikator indOznaka;
    private ButtonGroup buttonGroupAnalitika;
    private PzNumericOnlyTextField oznaka;
    private PzTextField naziv;
    private PzButton btnOK;
    private JPanel pnlButtons;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private JRadioButton vrsta1;
    private JRadioButton vrsta2;
    private JRadioButton vrsta3;
    private JRadioButton vrsta4;
    private JRadioButton vrsta5;
    private Konto kkk;
    private String old;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(498, 184));
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{25, 25, 25, 25, 25, 25, 25};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            panelLayout.columnWidths = new int[]{100, 72, 44, 49, 90, 25};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Oznaka konta");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Naziv konta");
            this.oznaka = new PzNumericOnlyTextField();
            this.panel.add((Component)this.oznaka, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.oznaka.setFont(new Font("Tahoma", 0, 14));
            this.oznaka.setMaxLength(6);
            this.oznaka.setSize(80, 24);
            this.oznaka.setPKField(Konto.class, null);
            this.oznaka.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        return PzEntityManager.find(Konto.class, (Object)new KontoPK(Dodavanje.this.oznaka.getVal(), ""));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)Dodavanje.this.oznaka, (Throwable)e);
                        return null;
                    }
                }
            });
            this.naziv = new PzTextField();
            this.panel.add((Component)this.naziv, (Object)new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.naziv.setFont(new Font("Tahoma", 0, 14));
            this.naziv.setSize(80, 24);
            this.naziv.setVerifyInput(true);
            this.buttonGroupAnalitika = new ButtonGroup();
            this.vrsta1 = new JRadioButton("Bez analitike");
            this.vrsta1.setActionCommand(TipAnalitika.ANALITIKA_BEZ_ANALITIKE);
            this.vrsta2 = new JRadioButton("TipAnalitika: POREZ");
            this.vrsta2.setActionCommand(TipAnalitika.ANALITIKA_POREZ);
            this.vrsta3 = new JRadioButton("TipAnalitika: RADNE JEDINICE");
            this.vrsta3.setActionCommand(TipAnalitika.ANALITIKA_RJ);
            this.vrsta4 = new JRadioButton("TipAnalitika: KOMITENTI");
            this.vrsta4.setActionCommand(TipAnalitika.ANALITIKA_KOMINTENTI);
            this.vrsta5 = new JRadioButton("SLOBODNA analitika");
            this.vrsta5.setActionCommand(TipAnalitika.ANALITIKA_SLOBODNA);
            this.buttonGroupAnalitika.add(this.vrsta1);
            this.buttonGroupAnalitika.add(this.vrsta2);
            this.buttonGroupAnalitika.add(this.vrsta3);
            this.buttonGroupAnalitika.add(this.vrsta4);
            this.buttonGroupAnalitika.add(this.vrsta5);
            this.panel.add((Component)this.vrsta1, (Object)new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.vrsta2, (Object)new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.vrsta3, (Object)new GridBagConstraints(1, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.vrsta4, (Object)new GridBagConstraints(1, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.vrsta5, (Object)new GridBagConstraints(1, 6, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.indOznaka = new PzFieldIndikator();
            this.panel.add((Component)this.indOznaka, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indNaziv = new PzFieldIndikator();
            this.panel.add((Component)this.indNaziv, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(494, 55));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(91, 12, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.oznaka.setStateIndikator(this.indOznaka);
            this.naziv.setStateIndikator(this.indNaziv);
            this.setSize(600, 400);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        } else if (actionCommand.equals("insert") && this.checkOznaka()) {
            Konto konto = new Konto(this.oznaka.getText(), "", PzSwingUtility.getSelectedValue((ButtonGroup)this.buttonGroupAnalitika), this.naziv.getVal());
            this.getTable().insert((PzEntity)konto, true);
            this.dispose();
        } else if (actionCommand.equals("update") && this.checkOznaka()) {
            Konto konto = (Konto)this.getTable().getSelectedEntity();
            konto.setNaziv(this.naziv.getVal());
            konto.setTipAnalitike(PzSwingUtility.getSelectedValue((ButtonGroup)this.buttonGroupAnalitika));
            this.getTable().updateSelectedEntity((PzEntity)konto, true);
            this.kkk = konto;
            this.azurirajStavke(PzSwingUtility.getSelectedValue((ButtonGroup)this.buttonGroupAnalitika));
            this.dispose();
        }
    }

    private void azurirajStavke(String selectedValue) {
        block13: {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                int res;
                Long cnt;
                if ("R".equals(selectedValue)) {
                    cnt = (Long)em.createNativeQuery("SELECT COUNT(*) from stavkanzk WHERE oznKonto='" + this.oznaka.getVal() + "' and oznRj is null and analitika=''").getSingleResult();
                    if (!cnt.equals(new Long(0L))) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Na trazenom kontu u glavnoj knjizi postoje knjizenja izvan analitike \n i zbog toga azuriranje glavne knjige ne moze biti uradjeno. \n Nazovite podrsku za detalje. ");
                        return;
                    }
                    em.getTransaction().begin();
                    Query q = em.createQuery("SELECT DISTINCT s.radnajedinica.id.oznRj FROM Stavkanzk s WHERE s.id.analitika='' and s.id.oznKonto='" + this.oznaka.getVal() + "'");
                    List oznRjs = q.getResultList();
                    for (String oznRj : oznRjs) {
                        Radnajedinica rj = (Radnajedinica)em.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", oznRj));
                        String anl = String.valueOf(PzEntityUtil.strZero((String)oznRj, (int)3)) + rj.getgTip();
                        Konto k = (Konto)em.find(Konto.class, (Object)new KontoPK(this.oznaka.getVal(), anl));
                        if (k == null) {
                            Konto ktmp = (Konto)BeanUtils.cloneBean((Object)this.kkk);
                            ktmp.setId(new KontoPK(this.kkk.getId().getOznKonto(), anl));
                            ktmp.setTipAnalitike("");
                            em.persist((Object)ktmp);
                        }
                        em.createNativeQuery("UPDATE Stavkanzk set analitika = '" + anl + "' WHERE oznKonto='" + this.oznaka.getVal() + "' and oznRj='" + oznRj + "' and analitika=''").executeUpdate();
                    }
                    em.getTransaction().commit();
                    break block13;
                }
                if (!"".equals(selectedValue)) break block13;
                em.getTransaction().begin();
                if (this.old.equals("R") && !(cnt = (Long)em.createNativeQuery("SELECT COUNT (*) FROM Stavkanzk WHERE oznkonto='" + this.oznaka.getVal() + "' AND analitika!='' and sfrKnjizenja='1'").getSingleResult()).equals(new Long(0L)) && (res = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"U glavnog knjizi postoje stavke knjizene van analitike.\n Da li zelite da azurirate glavnu knjigu?", (String)"Upozorenje", null, (boolean)true)) != 0) {
                    em.getTransaction().commit();
                    return;
                }
                try {
                    em.createNativeQuery("UPDATE Stavkanzk set analitika = '' WHERE oznKonto='" + this.oznaka.getVal() + "'").executeUpdate();
                    em.getTransaction().commit();
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Throwable)e);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private boolean checkOznaka() {
        if (this.oznaka.getText().length() != 6) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Oznaka konta mora sadr\u017eati ta\u010dno 6 cifara");
            this.oznaka.requestFocusInWindow();
        }
        return this.oznaka.getText().length() == 6;
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
        this.vrsta1.setSelected(true);
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        this.oznaka.setEnabled(false);
        Konto konto = (Konto)this.getTable().getSelectedEntity();
        this.oznaka.setVal((Object)konto.getId().getOznKonto());
        this.naziv.setVal((Object)konto.getNaziv());
        PzSwingUtility.setSelectedValue((String)konto.getTipAnalitike(), (ButtonGroup)this.buttonGroupAnalitika);
        this.panel.updateAllFieldsState();
        this.old = konto.getTipAnalitike();
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Otvaranje novog konta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena konta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_edit.png")));
    }
}

