/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import com.helger.ubl21.UBL21WriterBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.FinancialAccountType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxInclusiveAmountType;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaopstidokument;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;
import rs.pezar.efaktura.EDokumentExporter;
import rs.pezar.exceptions.PzInfoException;

public abstract class EZaduzenjeOdobrenjeExporter<T>
extends EDokumentExporter<ZaduzenjeOdobrenje, T> {
    private ZaduzenjeOdobrenje z;

    public EZaduzenjeOdobrenjeExporter(ZaduzenjeOdobrenje dokument) {
        super(dokument);
        this.z = dokument;
    }

    @Override
    public abstract T build() throws Exception;

    protected abstract String getInvoiceNumber();

    protected List<BillingReferenceType> billingReference() {
        if (this.z.getFakturaopstidokuments() != null && this.z.getFakturaopstidokuments().size() > 0) {
            ArrayList<BillingReferenceType> list = new ArrayList<BillingReferenceType>();
            for (Fakturaopstidokument f : this.z.getFakturaopstidokuments()) {
                BillingReferenceType b = new BillingReferenceType();
                DocumentReferenceType r = new DocumentReferenceType();
                r.setID(f.getFaktura().getOznDokumenta());
                r.setIssueDate(this.date(f.getFaktura().getDatum()));
                b.setInvoiceDocumentReference(r);
                list.add(b);
            }
            return list;
        }
        return null;
    }

    @Override
    protected abstract UBL21WriterBuilder<T> builder();

    @Override
    protected String documentTaxExemptionCode() {
        String exemption = null;
        if (this.z.getFakturaopstidokuments() != null && this.z.getFakturaopstidokuments().size() > 0) {
            for (Fakturaopstidokument f : this.z.getFakturaopstidokuments()) {
                Faktura fak = f.getFaktura();
                Fakturaparameter p = fak.getFakturaparameter(fak.getIdDok(), "TAX_EXEMPTION");
                if (exemption != null || p == null) continue;
                exemption = p.getValue();
            }
        }
        return exemption;
    }

    protected MonetaryTotalType monetaryTotalType() throws Exception {
        MonetaryTotalType m = new MonetaryTotalType();
        LineExtensionAmountType le = new LineExtensionAmountType(this.taxableAmount());
        le.setCurrencyID("RSD");
        TaxExclusiveAmountType te = new TaxExclusiveAmountType(this.taxableAmount());
        te.setCurrencyID("RSD");
        TaxInclusiveAmountType ti = new TaxInclusiveAmountType(this.taxableAmount().add(this.taxAmount()));
        ti.setCurrencyID("RSD");
        AllowanceTotalAmountType t = new AllowanceTotalAmountType(BigDecimal.ZERO);
        t.setCurrencyID("RSD");
        PrepaidAmountType p = new PrepaidAmountType(BigDecimal.ZERO);
        p.setCurrencyID("RSD");
        PayableAmountType pa = new PayableAmountType(this.z.getIznos());
        pa.setCurrencyID("RSD");
        m.setLineExtensionAmount(le);
        m.setTaxExclusiveAmount(te);
        m.setTaxInclusiveAmount(ti);
        m.setAllowanceTotalAmount(t);
        m.setPrepaidAmount(p);
        m.setPayableAmount(pa);
        return m;
    }

    @Override
    protected List<PzTaksaDokument> taksaDokuments() {
        ArrayList<PzTaksaDokument> list = new ArrayList<PzTaksaDokument>();
        if (this.z.getFakturaopstidokuments() != null && this.z.getFakturaopstidokuments().size() > 0) {
            for (Fakturaopstidokument f : this.z.getFakturaopstidokuments()) {
                list.addAll(f.getTaksafods());
            }
        }
        return list;
    }

    @Override
    protected PaymentMeansType paymentMeans(String id) {
        PaymentMeansType p = new PaymentMeansType();
        p.setPaymentMeansCode("30");
        FinancialAccountType f = new FinancialAccountType();
        f.setID("RS" + this.getBankAccount());
        p.setPayeeFinancialAccount(f);
        return p;
    }

    @Override
    protected void validateRequiredData() throws PzInfoException {
        super.validateRequiredData();
        ArrayList<String> exemptions = new ArrayList<String>();
        String noexemption = "noexemption";
        if (this.z.getFakturaopstidokuments() != null && this.z.getFakturaopstidokuments().size() > 0) {
            for (Fakturaopstidokument f : this.z.getFakturaopstidokuments()) {
                Faktura fak = f.getFaktura();
                Fakturaparameter p = fak.getFakturaparameter(fak.getIdDok(), "TAX_EXEMPTION");
                if (p != null) {
                    this.addStringIfNotExists(p.getValue(), exemptions);
                    continue;
                }
                this.addStringIfNotExists(noexemption, exemptions);
            }
        }
        if (exemptions.size() > 1) {
            throw new PzInfoException("Knjizno Odobrenje/zaduzenje ne moze obuhvatati fakture sa\r\nrazlicitim osnovama za oslobodjenje od PDV-a");
        }
    }

    private void addStringIfNotExists(String string, List<String> list) {
        if (!list.contains(string)) {
            list.add(string);
        }
    }
}

