/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import com.helger.ubl21.UBL21Writer;
import com.helger.ubl21.UBL21WriterBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;
import rs.pezar.efaktura.EZaduzenjeOdobrenjeExporter;
import rs.pezar.util.PzDateUtility;

public class EOdobrenjeExporter
extends EZaduzenjeOdobrenjeExporter<CreditNoteType> {
    private static final String CUSTOMIZATION_ID = "urn:cen.eu:en16931:2017#compliant#urn:mfin.gov.rs:srbdt:2022";
    private static final String CREDIT_NOTE_TYPE_CODE = "381";
    private ZaduzenjeOdobrenje z;

    public EOdobrenjeExporter(ZaduzenjeOdobrenje z) {
        super(z);
        this.z = z;
    }

    @Override
    public CreditNoteType build() throws Exception {
        CreditNoteType i = new CreditNoteType();
        i.setCustomizationID(CUSTOMIZATION_ID);
        i.setCreditNoteTypeCode(CREDIT_NOTE_TYPE_CODE);
        i.setProfileID("eRacun");
        i.setDocumentCurrencyCode("RSD");
        i.setID(this.getInvoiceNumber());
        i.setIssueDate(LocalDate.now());
        i.setDelivery(this.getDelivery());
        i.addInvoicePeriod(this.invoicePeriod());
        i.setAccountingSupplierParty(this.supplier());
        i.setAccountingCustomerParty(this.customer());
        i.addContractDocumentReference(this.contractReference());
        i.addTaxTotal(this.taxTotal());
        i.setBillingReference(this.billingReference());
        i.addPaymentMeans(this.paymentMeans(this.pb(this.z.getOznDokumenta())));
        i.setLegalMonetaryTotal(this.monetaryTotalType());
        i.setCreditNoteLine(this.lines());
        i.setNote(this.note());
        return i;
    }

    private List<DeliveryType> getDelivery() {
        DeliveryType d = new DeliveryType();
        d.setActualDeliveryDate(this.z.getDatValute().toLocalDate());
        return Arrays.asList(d);
    }

    private List<NoteType> note() {
        return Arrays.asList(new NoteType(this.z.getPoruka()));
    }

    private PeriodType invoicePeriod() {
        PeriodType period = new PeriodType();
        period.addDescriptionCode(new DescriptionCodeType("0"));
        return period;
    }

    private List<CreditNoteLineType> lines() {
        TaxTotalType t = this.taxTotal();
        ArrayList<CreditNoteLineType> lines = new ArrayList<CreditNoteLineType>();
        int count = 0;
        for (TaxSubtotalType s : t.getTaxSubtotal()) {
            CreditNoteLineType line = new CreditNoteLineType();
            line.setID("" + ++count);
            CreditedQuantityType q = new CreditedQuantityType(BigDecimal.ONE);
            q.setUnitCode("H87");
            line.setCreditedQuantity(q);
            LineExtensionAmountType ea = new LineExtensionAmountType(s.getTaxableAmountValue());
            ea.setCurrencyID("RSD");
            line.setLineExtensionAmount(ea);
            TaxTotalType tt = new TaxTotalType();
            tt.setTaxAmount(s.getTaxAmount());
            tt.addTaxSubtotal(s);
            line.addTaxTotal(tt);
            ItemType i = new ItemType();
            i.setName("Knjizno odobrenje  " + s.getTaxCategory().getPercentValue() + "%");
            i.addClassifiedTaxCategory(this.taxCategory("VAT", s.getTaxCategory().getPercentValue()));
            PriceType p = new PriceType();
            PriceAmountType pa = new PriceAmountType();
            pa.setCurrencyID("RSD");
            pa.setValue(s.getTaxableAmountValue());
            p.setPriceAmount(pa);
            line.setPrice(p);
            line.setItem(i);
            lines.add(line);
        }
        return lines;
    }

    @Override
    protected String getInvoiceNumber() {
        return "KO" + this.z.getOznDokumenta() + "/" + PzDateUtility.getCurrentYear();
    }

    @Override
    protected UBL21WriterBuilder<CreditNoteType> builder() {
        return UBL21Writer.creditNote();
    }
}

