/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import rs.pezar.efaktura.EDokumentAttachments;
import rs.pezar.efaktura.gui.PzPanelAttachment;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogAttachments
extends PzDialog {
    private static final long serialVersionUID = -804800124377048463L;
    private List<PzPanelAttachment> panels = Arrays.asList(new PzPanelAttachment("Prilog 1"), new PzPanelAttachment("Prilog 2"));
    private List<DocumentReferenceType> references;

    public PzDialogAttachments(PzDialog frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle("Dodavanje priloga uz E-Fakturu");
        try {
            BoxLayout thisLayout = new BoxLayout(this.getContentPane(), 1);
            this.getContentPane().setLayout(thisLayout);
            int spacing = 10;
            this.getContentPane().add(Box.createRigidArea(new Dimension(1, spacing)));
            this.getContentPane().add(new JLabel("Odaberite dokumente za slanje uz E-Fakturu"));
            for (PzPanelAttachment panel : this.panels) {
                this.getContentPane().add(Box.createRigidArea(new Dimension(1, spacing)));
                this.getContentPane().add(panel);
                this.getContentPane().add(Box.createRigidArea(new Dimension(1, spacing)));
            }
            JButton btn = new JButton("Potvrdi");
            btn.addActionListener((ActionListener)((Object)this));
            this.getContentPane().add(btn);
            this.getContentPane().add(Box.createRigidArea(new Dimension(1, spacing)));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<DocumentReferenceType> getDocumentReferences() throws IOException {
        ArrayList<DocumentReferenceType> references = new ArrayList<DocumentReferenceType>();
        for (PzPanelAttachment panel : this.panels) {
            DocumentReferenceType r = panel.getDocumentReference();
            if (r == null) continue;
            references.add(r);
        }
        return references;
    }

    public static EDokumentAttachments getDocumentReferences(PzDialog parent) {
        PzDialogAttachments dlg = new PzDialogAttachments(parent);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setVisible(true);
        return new EDokumentAttachments(dlg.references);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.references = this.getDocumentReferences();
            this.dispose();
        }
        catch (IOException e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }
}

