/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.EmbeddedDocumentBinaryObjectType;
import org.jdesktop.application.Application;
import rs.pezar.swing.util.PzSwingUtility;

public class PzPanelAttachment
extends JPanel {
    private JTextField txtPath;
    private JTextField txtNaziv;
    private JPanel jPanel2;
    private JLabel lblNaziv;
    private JPanel jPanel1;
    private JButton btn;
    private String name;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PzPanelAttachment(""));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzPanelAttachment(String name) {
        this.name = name;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(420, 91));
            GridBagLayout thisLayout = new GridBagLayout();
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.name, 4, 0));
            thisLayout.rowWeights = new double[]{0.1, 0.1};
            thisLayout.rowHeights = new int[]{20, 7};
            thisLayout.columnWeights = new double[]{0.1};
            thisLayout.columnWidths = new int[]{7};
            this.setLayout(thisLayout);
            this.jPanel1 = new JPanel();
            this.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtPath = new JTextField();
            this.jPanel1.add(this.txtPath);
            this.txtPath.setPreferredSize(new Dimension(288, 23));
            this.txtPath.setName("txtPath");
            this.btn = new JButton("Izbor dokumenta");
            this.jPanel1.add(this.btn);
            this.btn.addActionListener(this.onButtonClicked());
            this.jPanel2 = new JPanel();
            this.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblNaziv = new JLabel();
            this.jPanel2.add(this.lblNaziv);
            this.lblNaziv.setName("lblNaziv");
            this.txtNaziv = new JTextField();
            this.jPanel2.add(this.txtNaziv);
            this.txtNaziv.setPreferredSize(new Dimension(312, 23));
            this.txtNaziv.setText(this.name);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ActionListener onButtonClicked() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                chooser.setDialogTitle("Izaberite dokument kao prilog");
                FileNameExtensionFilter restrict = new FileNameExtensionFilter("PDF", "pdf");
                chooser.setFileFilter(restrict);
                int r = chooser.showOpenDialog(null);
                if (r == 0) {
                    if (!chooser.getSelectedFile().getName().toLowerCase().endsWith("pdf")) {
                        PzSwingUtility.showErrorMessage((Component)PzPanelAttachment.this, (String)"Izabrani dokument mora biti u PDF formatu.");
                    } else if (chooser.getSelectedFile().length() / 1024L / 1024L > 20L) {
                        PzSwingUtility.showErrorMessage((Component)PzPanelAttachment.this, (String)"Fajl je preveliki. Velicina priloga ne sme biti veca od 20 MB.");
                    } else {
                        PzPanelAttachment.this.txtPath.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            }
        };
    }

    private String getPath() {
        String path = this.txtPath.getText();
        return path.equals("") ? null : path;
    }

    public DocumentReferenceType getDocumentReference() throws IOException {
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(Files.readAllBytes(f.toPath()));
        DocumentReferenceType ref = new DocumentReferenceType();
        ref.setID(this.txtNaziv.getText().equals("") ? this.name.replace(" ", "-") : this.txtNaziv.getText().replace(" ", "-"));
        AttachmentType att = new AttachmentType();
        EmbeddedDocumentBinaryObjectType e = new EmbeddedDocumentBinaryObjectType();
        e.setMimeCode("application/pdf");
        e.setValue(os.toByteArray());
        att.setEmbeddedDocumentBinaryObject(e);
        ref.setAttachment(att);
        try {
            os.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return ref;
    }
}

