/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.kasa.gui.PzDialogIzradaMaloprodajnogRacunaNew;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class IzmenaStavke
extends PzDialog {
    private static final long serialVersionUID = -4346048577551487098L;
    private PzPanel pnlContent;
    private JButton btnOK;
    private JLabel lblKolicina;
    private PzDoubleField dfPopust;
    private JLabel lblRabat;
    private PzDoubleField dblCena;
    private PzDoubleField dblKolicina;
    private JLabel lblCena;
    private PzPanel pnlForm;
    private PzPanelHeader header;
    private PzTable table;
    private Proizvodfiskalniracun stavka;
    private Radnajedinica rj;
    private Stanjeartikal a;
    private boolean updateKolicine;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                IzmenaStavke inst = new IzmenaStavke(frame);
                inst.setVisible(true);
            }
        });
    }

    public IzmenaStavke(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public IzmenaStavke(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.rj = (Radnajedinica)this.getSession().getParameter("kasa_rj");
        this.table = (PzTable)this.getSession().getParameter("kasa_table");
        this.stavka = (Proizvodfiskalniracun)this.table.getSelectedEntity();
        this.dblKolicina.setVal((Object)this.stavka.getKolicina());
        this.dblCena.setVal((Object)this.stavka.getCena());
        this.dfPopust.setVal((Object)this.stavka.getProcRabata());
        this.paintPanel();
        try {
            this.a = (Stanjeartikal)PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(this.stavka.getId().getSfrProizvod(), this.rj));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_CENE") == null) {
            this.dblCena.setEnabled(false);
        }
        if (!"stavka".equals(PzParameter.getParameterValue((String)"KASA_POPUST", (String)"")) || PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_RABATA") == null) {
            this.dfPopust.setEnabled(false);
        }
        this.updateKolicine = ((PzDialogIzradaMaloprodajnogRacunaNew)parent).isUpdateKolicine();
    }

    private void paintPanel() {
        this.pnlContent.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlContent.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlContent.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout blayout = new BorderLayout();
            this.setLayout(blayout);
            this.setTitle("A\u017euriranje");
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.header = new PzPanelHeader();
            this.header.setTitle("A\u017euriranje");
            this.header.setText("A\u017euriranje koli\u010dine i cene");
            this.header.setIcon(new ImageIcon(IzmenaStavke.class.getResource("/rs/pezar/kasa/resource/img/row_preferences.png")));
            this.pnlContent.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setOpaque(false);
            this.pnlForm = new PzPanel();
            GridBagLayout pnlFormLayout = new GridBagLayout();
            pnlFormLayout.columnWeights = new double[]{0.0, 0.1};
            pnlFormLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFormLayout.columnWidths = new int[]{143, 7};
            pnlFormLayout.rowHeights = new int[]{7, 7, 20, 7};
            this.pnlContent.add((Component)this.pnlForm, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlForm.setLayout((LayoutManager)pnlFormLayout);
            this.pnlForm.setOpaque(false);
            this.lblKolicina = new JLabel("Koli\u010dina:");
            this.pnlForm.add((Component)this.lblKolicina, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.lblCena = new JLabel("Cena:");
            this.pnlForm.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.dblKolicina = new PzDoubleField();
            this.dblKolicina.setColumns(8);
            this.pnlForm.add((Component)this.dblKolicina, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 5), 0, 0));
            this.dblKolicina.setName("dblKolicina");
            this.dblKolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.dblKolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (IzmenaStavke.this.stavka.getTaksa("PDV").getOznTarGr().startsWith("U")) {
                        return true;
                    }
                    if (IzmenaStavke.this.rj.getTip().equals("EL") && IzmenaStavke.this.rj.getMinusKolicine().equals("ZABRANJEN") && IzmenaStavke.this.a.getRaspKolicina() + IzmenaStavke.this.stavka.getKolicina() <= 0.0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)IzmenaStavke.this), (String)"Nema dovoljno raspolo\u017eive koli\u010dine!");
                        return false;
                    }
                    return true;
                }
            });
            this.dblCena = new PzDoubleField();
            this.dblCena.setColumns(8);
            this.pnlForm.add((Component)this.dblCena, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 5), 0, 0));
            this.dblCena.setName("dblCena");
            this.btnOK = new JButton();
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.pnlForm.add((Component)this.btnOK, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setText("Izmeni       ");
            this.btnOK.setIcon(new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/check.png")));
            this.lblRabat = new JLabel();
            this.pnlForm.add((Component)this.lblRabat, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblRabat.setName("lblRabat");
            this.dfPopust = new PzDoubleField();
            this.pnlForm.add((Component)this.dfPopust, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 3, 5), 0, 0));
            this.dfPopust.setColumns(8);
            this.setSize(377, 227);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            em.getTransaction().begin();
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.a.getId().getSfrProizvod(), this.rj));
            if (!this.stavka.getTaksa("PDV").getOznTarGr().startsWith("U") && this.rj.getpTip().equals("L") && this.rj.getMinusKolicine().equals("ZABRANJEN") && s.getRaspolozivaKolicina() + this.stavka.getKolicina() - this.dblKolicina.getVal() < 0.0) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nema dovoljno raspolo\u017eive koli\u010dine!");
                return;
            }
            try {
                if (this.updateKolicine) {
                    s.setAlocKolicina(s.getAlocKolicina() - this.stavka.getKolicina() + this.dblKolicina.getVal());
                }
                this.stavka.setKolicina(this.dblKolicina.getVal().doubleValue());
                this.stavka.setCena(this.dblCena.getVal().doubleValue());
                this.stavka.setProcRabata(this.dfPopust.getVal().doubleValue());
                this.table.updateSelectedEntity((PzEntity)this.stavka, em);
                em.getTransaction().commit();
                this.table.commitUpdate();
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        finally {
            em.close();
        }
    }
}

