/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.db.PzADTaksa;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.kasa.gui.PzDialogIzradaMaloprodajnogRacunaNew;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.BuyerIdentification;
import rs.pezar.kasa.lpfr.model.InvoiceResponse;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.model.RequestParams;
import rs.pezar.kasa.lpfr.rest.LPFRClient;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogFaktura
extends PzDialog {
    private static final long serialVersionUID = -8623631508687990340L;
    private JPanel mainPanel;
    private PzDateField dfDatumValute;
    private PzButton btnOk;
    private JLabel lblHBKJSopis;
    private PzTextField txtJBKJS;
    private JLabel lblJBKJS;
    private JLabel lblRok;
    private PzTextField tfNazivKupca;
    private PzNumericOnlyTextField tfSifraKupca;
    private JLabel lblKupac;
    private PzPanelHeader pnlHeader;
    private Komitent kupac;
    private Fiskalniracun racun;
    private Boolean updateKolicine;
    private PzBusyPainterUI layerUI;
    private JXLayer<Component> layer;

    public PzDialogFaktura(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogFaktura(PzDialog frame) {
        super(frame);
        this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
        this.updateKolicine = (Boolean)this.getSession().getParameter("updateKolicine");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.mainPanel = new JPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.mainPanel, (LayerUI)this.layerUI);
            this.getContentPane().add((Component)this.layer, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0, 0.1};
            pnlContentLayout.rowHeights = new int[]{7, 7, 20, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlContentLayout.columnWidths = new int[]{7, 112, 7, 7};
            this.mainPanel.setLayout(pnlContentLayout);
            this.mainPanel.setPreferredSize(new Dimension(472, 194));
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setOpaque(false);
            this.pnlHeader.setTitle("Izdavanje fakture");
            this.pnlHeader.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/cashier1.png")));
            this.mainPanel.add((Component)this.pnlHeader, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKupac = new JLabel();
            this.mainPanel.add((Component)this.lblKupac, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.lblKupac.setText("Kupac");
            this.tfSifraKupca = new PzNumericOnlyTextField();
            this.tfSifraKupca.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.mainPanel.add((Component)this.tfSifraKupca, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.tfSifraKupca.setName("tfSifraKupca");
            this.tfNazivKupca = new PzTextField();
            this.mainPanel.add((Component)this.tfNazivKupca, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
            this.tfNazivKupca.setName("tfNazivKupca");
            this.dfDatumValute = new PzDateField();
            this.mainPanel.add((Component)this.dfDatumValute, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.lblRok = new JLabel();
            this.mainPanel.add((Component)this.lblRok, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 5), 0, 0));
            this.lblRok.setName("lblRok");
            this.btnOk = new PzButton();
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.mainPanel.add((Component)this.btnOk, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.btnOk.setName("btnOk");
            this.lblJBKJS = new JLabel();
            this.mainPanel.add((Component)this.lblJBKJS, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.lblJBKJS.setName("lblJBKJS");
            this.txtJBKJS = new PzTextField();
            this.mainPanel.add((Component)this.txtJBKJS, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.lblHBKJSopis = new JLabel();
            this.mainPanel.add((Component)this.lblHBKJSopis, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblHBKJSopis.setName("lblHBKJSopis");
            this.setSize(488, 237);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.kupac = (Komitent)entity;
            this.kupac = (Komitent)PzEntityManager.getEm().find(Komitent.class, (Object)this.kupac.getSfrKomitent());
            this.tfSifraKupca.setVal((Object)this.kupac.getSfrKomitent());
            this.tfNazivKupca.setText(this.kupac.getNaziv());
            Komitentparameter jbkjs = this.kupac.getKomitentparameter("JBKJS");
            if (jbkjs != null) {
                this.txtJBKJS.setVal((Object)jbkjs.getValue());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.kupac == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate izabrati kupca", "Greska", 0);
            return;
        }
        if (this.kupac.getPib() == null || this.kupac.getPib().trim().equals("")) {
            this.layerUI.setLocked(true);
        }
        SwingWorker<InvoiceResponse, Object> worker = new SwingWorker<InvoiceResponse, Object>(){

            @Override
            protected InvoiceResponse doInBackground() throws Exception {
                String buyerId;
                LPFRClient client = new LPFRClient();
                client.attention();
                PzDialogFaktura.this.ocisti();
                Boolean bezKase = (Boolean)PzDialogFaktura.this.getSession().getParameter("bez_kase");
                if (bezKase == null) {
                    bezKase = Boolean.FALSE;
                }
                InvoiceTransaction it = InvoiceTransaction.NORMAL_SALE;
                if (!PzDialogFaktura.this.pripremiRacunZaStampu(false, true)) {
                    return null;
                }
                String string = buyerId = PzDialogFaktura.this.txtJBKJS.getText().trim().equals("") ? BuyerIdentification.PIB_KUPCA.value(PzDialogFaktura.this.kupac.getPib()) : BuyerIdentification.PIB_JBKJS.value(PzDialogFaktura.this.kupac.getPib());
                if (!PzDialogFaktura.this.txtJBKJS.getText().trim().equals("")) {
                    buyerId = String.valueOf(buyerId) + ":" + PzDialogFaktura.this.txtJBKJS.getText().trim();
                }
                RequestParams.Builder builder = RequestParams.getBuilder().withInvoiceType(it.getInvoiceType()).withTransactionType(it.getTransactionType()).withPayment("WireTransfer", PzDialogFaktura.this.racun.getIznos()).withValidTo(PzDialogFaktura.this.dfDatumValute.getVal()).withBuyerId(buyerId).withCopyWithSignature(true);
                client.setTaxMap(PzEntityManager.getList((String)"SELECT t FROM TaxMap t"));
                return client.createInvoice(PzDialogFaktura.this.racun, builder.build());
            }

            @Override
            protected void done() {
                block9: {
                    Boolean bezKase = PzDialogFaktura.this.getSession() != null && PzDialogFaktura.this.getSession().getParameter("bez_kase") != null ? (Boolean)PzDialogFaktura.this.getSession().getParameter("bez_kase") : Boolean.FALSE;
                    try {
                        InvoiceResponse odstampan = (InvoiceResponse)this.get();
                        if (odstampan == null) {
                            return;
                        }
                        try {
                            PzDialogFaktura.this.racun.setLpfrBroj(odstampan.getInvoiceNumber());
                            PzDialogFaktura.this.racun.setLpfrVreme(odstampan.getSdcDateTime());
                            PzDialogFaktura.this.arhivirajRacun(bezKase);
                            PzKasaUtil.napraviFakturu(PzDialogFaktura.this.racun, PzDialogFaktura.this.kupac, PzDialogFaktura.this.dfDatumValute.getVal());
                            PzDialogFaktura.this.napraviPrazanRacun();
                            PzDialogFaktura.this.dispose();
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof LPFRException) {
                                JOptionPane.showMessageDialog((Component)((Object)PzDialogFaktura.this), ((LPFRException)e.getCause()).getFullMessage(), "L-PFR greska", 0);
                                break block9;
                            }
                            if (!(e instanceof OptimisticLockException) && !(e instanceof OptimisticLockException)) {
                                PzMysqlExceptionHandler.handle((Throwable)e);
                                break block9;
                            }
                            e.printStackTrace();
                        }
                    }
                    finally {
                        PzDialogFaktura.this.layerUI.setLocked(false);
                    }
                }
            }
        };
        worker.execute();
    }

    private void ocisti() {
        block2: {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                em.getTransaction().begin();
                em.createQuery("DELETE FROM Taksafiskalniracun t WHERE t.id.idDok=" + this.racun.getIdDok()).executeUpdate();
                em.createQuery("DELETE FROM Dtaksa t WHERE t.id.idDok=" + this.racun.getIdDok()).executeUpdate();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Throwable)e);
                if (!em.getTransaction().isActive()) break block2;
                em.getTransaction().commit();
            }
        }
    }

    private boolean pripremiRacunZaStampu(boolean arhiviraj, boolean saNivelacijom) throws Exception {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        boolean nivSuccess = !saNivelacijom;
        try {
            em.getTransaction().begin();
            InvoiceTransaction it = InvoiceTransaction.NORMAL_SALE;
            if (it.equals(InvoiceTransaction.NORMAL_SALE) && !PzKasaUtil.proveriStanje(this.racun, em)) {
                return false;
            }
            this.racun = (Fiskalniracun)em.createQuery("SELECT f FROM Fiskalniracun F JOIN FETCH f.proizvodfiskalniracuns JOIN FETCH f.dokument WHERE f.idDok=" + this.racun.getIdDok()).getSingleResult();
            this.racun.setTip(it.getInvoiceType().equals("Normal") ? "FISKALNI_RACUN" : "ISECAK");
            this.racun.setPodTip(it.getValue());
            this.racun.setStorno(it.getTransactionType().equals("Refund") ? 1 : 0);
            this.racun.sumirajPopust();
            this.racun.primeniPopustNaCene();
            this.racun.setVirman(this.racun.getIznosRacuna());
            this.racun.setIdKupca(BuyerIdentification.PIB_KUPCA.value(this.kupac.getPib()));
            Timestamp datum = PzDateUtility.getServerTime((EntityManager)em);
            this.racun.setVreme(datum);
            Nivelacija nivelacija = null;
            if (saNivelacijom) {
                Faktura f = this.getFaktura(this.racun, em);
                nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)false, (boolean)true, (EntityManager)em);
                this.arhiviraj(nivelacija, em);
                nivSuccess = true;
            }
            if (this.kupac != null) {
                this.racun.setPib(this.kupac.getPib());
                this.racun.setMbr(this.kupac.getMatBroj());
                this.racun.setNazivKupca(this.kupac.getNaziv());
                this.racun.setAdresa(this.kupac.getAdresa());
                this.racun.setGrad(this.kupac.getGrad());
                this.racun.setKomitent((Komitent)em.find(Komitent.class, (Object)this.kupac.getSfrKomitent()));
            }
            PzKasaUtil.pripremiZaStampu(this.racun, em, arhiviraj);
            em.getTransaction().commit();
            if (nivelacija != null) {
                this.pnlHeader.setText("Registrovana je promena cene tako da \u0107e biti izra\u0111ena nivelacija.");
            }
            return true;
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (e instanceof OptimisticLockException || e instanceof OptimisticLockException) {
                boolean bl = this.pripremiRacunZaStampu(arhiviraj, !nivSuccess);
                return bl;
            }
            throw e;
        }
        finally {
            em.close();
        }
    }

    private void arhivirajRacun(boolean bezKase) throws Exception {
        try {
            PzKasaUtil.arhivirajRacun(this.racun, this.updateKolicine, bezKase);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof OptimisticLockException || cause != null && cause instanceof OptimisticLockException) {
                e.printStackTrace();
                this.arhivirajRacun(bezKase);
            }
            throw e;
        }
    }

    public Faktura getFaktura(Fiskalniracun racun, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(racun.getRadnajedinica());
        f.setDatum(PzDateUtility.getServerDate((EntityManager)em));
        f.setDatValute(this.dfDatumValute.getVal());
        for (Proizvodfiskalniracun proizvod : racun.getProizvodfiskalniracuns()) {
            if (proizvod.getId().getSfrProizvod().endsWith("U")) continue;
            Artikalfaktura af = new Artikalfaktura();
            Artikal a = (Artikal)em.find(Artikal.class, (Object)proizvod.getId().getSfrProizvod());
            af.setArtikal(a);
            af.setId(1, proizvod.getId().getSfrProizvod(), 1);
            af.setKolicina(proizvod.getKolicina());
            af.setCena(proizvod.getCena());
            af.setNaziv(proizvod.getNaziv());
            af.setJm(proizvod.getJm());
            af.setAftaksas(new Vector());
            if (proizvod.getTaksas() != null || proizvod.getTaksas().size() != 0) {
                for (PzADTaksa t : proizvod.getTaksas()) {
                    af.getAftaksas().add(new Aftaksa(f.getIdDok(), proizvod.getId().getSfrProizvod(), t.getOznTarGr(), 0, t.getStopa(), t.getOznVrstaTG(), ""));
                }
            }
            f.getArtikalfakturas().add(af);
        }
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void napraviPrazanRacun() {
        if (this.getSession().getParameter("izArhiveObrisanih") != null) {
            return;
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                if (!((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).getFiskalniRacun().booleanValue()) {
                    ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).createFiskalniRacun(em);
                }
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshDataTable();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).refreshIznos();
                ((PzDialogIzradaMaloprodajnogRacunaNew)((Object)this.getParent())).resetDialogData();
                em.getTransaction().commit();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                if (e instanceof OptimisticLockException || e.getCause() instanceof OptimisticLockException) {
                    this.napraviPrazanRacun();
                } else {
                    PzMysqlExceptionHandler.handle((Throwable)e);
                }
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

