/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.kasa.gui.util.KasaGradientUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogTotaliProdaje
extends PzDialog {
    private PzPanel mainPanel;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfKrajnjiDatum;
    private PzButton btnPotvrdi;
    private PzDateField dfPocetni;
    private JLabel lblPocetniDatum;
    private Radnajedinica rj;
    private ScrollableCursor cursor = null;
    private String parametar;

    public PzDialogTotaliProdaje(JFrame frame) {
        this(frame, "totali");
    }

    public PzDialogTotaliProdaje(JFrame frame, String parametar) {
        super(frame);
        this.parametar = parametar;
        this.initGUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (PzDialogTotaliProdaje.this.cursor != null && !PzDialogTotaliProdaje.this.cursor.isClosed()) {
                    PzDialogTotaliProdaje.this.cursor.close();
                }
            }
        });
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            if ("totaliObrisano".equals(this.parametar)) {
                this.setTitle("Totali prodaje - obrisano");
            } else {
                this.setTitle("Totali prodaje");
            }
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{108, 133, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblPocetniDatum = new JLabel();
            this.mainPanel.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblPocetniDatum.setName("lblPocetniDatum");
            this.dfPocetni = new PzDateField();
            this.mainPanel.add((Component)this.dfPocetni, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblKrajnjiDatum = new JLabel();
            this.mainPanel.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblKrajnjiDatum.setName("lblKrajnjiDatum");
            this.dfKrajnjiDatum = new PzDateField();
            this.mainPanel.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(125, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.pack();
            this.setSize(321, 176);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogTotaliProdaje.this.cursor != null) {
                        PzDialogTotaliProdaje.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    upit = "(SELECT cast(dok.vreme as date), dok.gotovina, dok.cekovi, dok.kartice, 0.0, dok.vrednostUsluga, dok.storno, dok.oznDokumenta, cast(dok.vreme as varchar), dok.pzusername FROM Fiskalniracun dok, Radnajedinica rj WHERE dok.tip = 'FISKALNI_RACUN' and dok.arhiviran = :arhiviran and cast(dok.vreme as date)>='%datumOd%' and cast(dok.vreme as date)<='%datumDo%' and dok.oznRj='%rj%' ) UNION ( SELECT dok.datum, 0.0, 0.0, 0.0, dok.iznos, dok.vrednostUsluga, dok.storno, dok.oznDokumenta, cast(dok.datum as varchar),  dok.usernamekraj FROM Faktura dok, Radnajedinica rj WHERE dok.tip = 'FISKALNI_RACUN' and dok.arhiviran = :arhiviran and dok.datum>='%datumOd%' and dok.datum<='%datumDo%' and dok.tip = '" + TipDokumentConfig.get().FAKTURA + "' and dok.oznRj='%rj%' )";
                    upit = String.valueOf(upit) + " ORDER BY 1, 10";
                    upit = upit.replace("%datumOd%", PzDialogTotaliProdaje.this.dfPocetni.getVal().toString());
                    upit = upit.replace("%datumDo%", PzDialogTotaliProdaje.this.dfKrajnjiDatum.getVal().toString());
                    upit = upit.replace("%rj%", PzDialogTotaliProdaje.this.rj.getId().getOznRj());
                    upit = "totaliObrisano".equals(PzDialogTotaliProdaje.this.parametar) ? upit.replace(":arhiviran", "-1") : upit.replace(":arhiviran", "1");
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogTotaliProdaje.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogTotaliProdaje.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogTotaliProdaje.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogTotaliProdaje.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogTotaliProdaje.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogTotaliProdaje.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Object> data = new Vector<Object>();
        data.add(PzFirma.getFirma());
        data.add(this.rj);
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "TOTALI PRODAJE U PERIODU OD " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " DO " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", PzDateUtility.getCurrentDate());
        params.put("reklama", "");
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/reports/compiled/totali.prodaje.jasper"), params, (String)title, (int)PzReportManager.REPORT_TYPE_JASPER);
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(KasaGradientUtil.MALOPRODAJNI_RACUN_GRADIENT);
        this.getSession().putParameter("gradient", (Object)KasaGradientUtil.MALOPRODAJNI_RACUN_GRADIENT);
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf('E')});
        return this.rj != null;
    }
}

