/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui.util;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzManageableTable;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.data.models.PzTableModel;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.renderers.PzTableCellRenderer;

public class PzArtikalfakturaCheckboxDialog
extends PzDialog {
    private static final long serialVersionUID = 726551917242014098L;
    private JScrollPane scp;
    private PzDoubleField dblUkupno;
    private JLabel lblUkupno;
    private JPanel pnlTotal;
    private PzButton btnOK;
    private PzPanel pnlContent;
    private PzPanelHeader header;
    private Object source;
    private PzManageableTable table;
    private Class<?> entityClass;
    private int checkBoxColumn;
    private PzEntityFilter filter;
    private static PzEntity selectedEntity;
    private static List<PzEntity> selectedEntities;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzArtikalfakturaCheckboxDialog inst = new PzArtikalfakturaCheckboxDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzArtikalfakturaCheckboxDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzArtikalfakturaCheckboxDialog(PzDialog parent, Object source, Class<?> type, int checkBoxColumn, PzEntityFilter filter) {
        super(parent);
        this.setId(String.valueOf(parent.getClass().getName()) + ((Object)((Object)this)).getClass().getName());
        this.source = source;
        this.entityClass = type;
        this.filter = filter;
        this.initGUI();
        this.checkBoxColumn = checkBoxColumn;
        this.instantiateTable();
    }

    private void initGUI() {
        try {
            this.pnlContent = new PzPanel();
            AnchorLayout pnlContentLayout = new AnchorLayout();
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.pnlTotal = new JPanel();
            FlowLayout pnlTotalLayout = new FlowLayout();
            pnlTotalLayout.setAlignment(0);
            this.pnlTotal.setLayout(pnlTotalLayout);
            this.pnlContent.add((Component)this.pnlTotal, (Object)new AnchorConstraint(835, 743, 965, 16, 1, 1, 1, 1));
            this.pnlTotal.setPreferredSize(new Dimension(563, 44));
            this.lblUkupno = new JLabel("Ukupno:");
            this.pnlTotal.add(this.lblUkupno);
            this.btnOK = new PzButton();
            this.pnlContent.add((Component)this.btnOK, (Object)new AnchorConstraint(842, 11, 11, 812, 0, 2, 2, 0));
            this.btnOK.setPreferredSize(new Dimension(135, 39));
            this.btnOK.setName("btnOK");
            this.btnOK.setAction(this.getAppActionMap().get((Object)"akcija"));
            this.header = new PzPanelHeader();
            this.header.setName("header");
            this.getContentPane().add((Component)this.header, "North");
            this.setSize(782, 416);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void instantiateTable() {
        if (this.source == null) {
            return;
        }
        if (this.source instanceof List) {
            this.table = new PzTable();
            this.table.setFilter(this.filter);
            this.table.setId(this.entityClass.getName());
            this.table.setModel((TableModel)new PzTableModel(){

                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    Artikalfaktura af = (Artikalfaktura)this.getEntity(rowIndex);
                    return af.getArtikalfakturaparameter("STAMPANO") == null;
                }

                public Object getValueAt(int rowIndex, int columnIndex) {
                    Artikalfaktura af = (Artikalfaktura)this.getEntity(rowIndex);
                    if (rowIndex == 0 && af.getArtikalfakturaparameter("STAMPANO") != null) {
                        this.selected.setElementAt(false, rowIndex);
                    }
                    return super.getValueAt(rowIndex, columnIndex);
                }
            });
            ((PzTable)this.table).setData((List)this.source, this.entityClass);
            this.table.addCheckboxListener(new PzTableCheckboxListener(){

                public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                    double iznos = 0.0;
                    for (Artikalfaktura a : PzArtikalfakturaCheckboxDialog.this.table.getCheckedEntities()) {
                        iznos += a.getKolicina() * a.getCena();
                    }
                    PzArtikalfakturaCheckboxDialog.this.dblUkupno.setVal((Object)iznos);
                }
            });
            this.table.setSortable(false);
            this.dblUkupno = this.table.createExpresionField("$4$");
            this.dblUkupno.setColumns(15);
            this.pnlTotal.add((Component)this.dblUkupno);
            this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PzTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Artikalfaktura a = (Artikalfaktura)((PzTable)table).getEntity(row);
                    Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (a.getArtikalfakturaparameter("STAMPANO") != null) {
                        renderer.setEnabled(false);
                    } else {
                        renderer.setEnabled(true);
                    }
                    return renderer;
                }
            });
        } else if (this.source instanceof ScrollableCursor) {
            this.table = new PzScrollableTableEntity(this.entityClass);
            this.table.setFilter(this.filter);
            ((PzScrollableTableEntity)this.table).read((ScrollableCursor)this.source);
        }
        if (this.checkBoxColumn != -1) {
            this.table.setCheckboxColumn(0);
        }
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            int i = 0;
            while (i < this.table.getRowCount()) {
                if (this.table.convertRowIndexToView(i) != -1 && ((Artikalfaktura)this.table.getEntity(i)).getArtikalfakturaparameter("STAMPANO") == null) {
                    this.table.setRowChecked(i, true);
                }
                ++i;
            }
        }
        this.scp = new JScrollPane();
        this.scp.setViewportView((Component)this.table);
        this.scp.setPreferredSize(new Dimension(750, 240));
        this.pnlContent.add((Component)this.scp, (Object)new AnchorConstraint(12, 12, 62, 12, 2, 2, 2, 2));
    }

    public static PzEntity showDialog(PzDialog parent, Class<?> type, List<?> list, String title, String text, PzEntityFilter filter) {
        PzArtikalfakturaCheckboxDialog dlg = new PzArtikalfakturaCheckboxDialog(parent, list, type, -1, filter);
        dlg.setHeaderTitle(title, text);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setId(type.getName());
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity selectedEntity = PzArtikalfakturaCheckboxDialog.selectedEntity;
        PzArtikalfakturaCheckboxDialog.selectedEntity = null;
        selectedEntities = null;
        return selectedEntity;
    }

    public static List<PzEntity> showDialog(PzDialog parent, Class<?> type, List<?> list, String title, String text, int checkBoxColumn, PzEntityFilter filter) {
        PzArtikalfakturaCheckboxDialog dlg = new PzArtikalfakturaCheckboxDialog(parent, list, type, checkBoxColumn, filter);
        dlg.setHeaderTitle(title, text);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setId(String.valueOf(type.getName()) + "_checkbox");
        dlg.restoreSize();
        dlg.setVisible(true);
        List<PzEntity> selectedEntities = PzArtikalfakturaCheckboxDialog.selectedEntities;
        selectedEntity = null;
        PzArtikalfakturaCheckboxDialog.selectedEntities = null;
        return selectedEntities;
    }

    public void actionPerformed(ActionEvent e) {
    }

    @Action
    public void akcija() {
        selectedEntity = this.table.getSelectedEntity();
        selectedEntities = this.table.getCheckedEntities();
        this.dispose();
    }

    private ApplicationActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap((Object)this);
    }

    private void setHeaderTitle(String title, String subtitle) {
        this.header.setTitle(title);
        this.header.setText(subtitle);
    }
}

