/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.lpfr.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import rs.pezar.kasa.lpfr.model.InvoicePayment;

public class RequestParams {
    private String dateAndTimeOfIssue;
    private String buyerId;
    private String buyerCostCenterId;
    private String invoiceType;
    private String transactionType;
    private String referentDocumentNumber;
    private String referentDocumentDT;
    private BigDecimal advance;
    private BigDecimal advanceTax;
    private Date validTo;
    private boolean copyWithSignature;
    private List<InvoicePayment> payment;

    private RequestParams(Builder b) {
        this.buyerCostCenterId = b.buyerCostCenterId;
        this.buyerId = b.buyerId;
        this.dateAndTimeOfIssue = b.dateAndTimeOfIssue;
        this.invoiceType = b.invoiceType;
        this.transactionType = b.transactionType;
        this.payment = b.payment;
        this.advance = b.advance;
        this.advanceTax = b.advanceTax;
        this.validTo = b.validTo;
        this.copyWithSignature = b.copyWithSignature;
        this.referentDocumentDT = b.referentDocumentDT;
        this.referentDocumentNumber = b.referentDocumentNumber;
    }

    public String getDateAndTimeOfIssue() {
        return this.dateAndTimeOfIssue;
    }

    public String getBuyerId() {
        return this.buyerId;
    }

    public String getBuyerCostCenterId() {
        return this.buyerCostCenterId;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getReferentDocumentNumber() {
        return this.referentDocumentNumber;
    }

    public String getReferentDocumentDT() {
        return this.referentDocumentDT;
    }

    public List<InvoicePayment> getPayment() {
        return this.payment;
    }

    public BigDecimal getAdvance() {
        return this.advance;
    }

    public BigDecimal getAdvanceTax() {
        return this.advanceTax;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public boolean isCopyWithSignature() {
        return this.copyWithSignature;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    /* synthetic */ RequestParams(Builder builder, RequestParams requestParams) {
        this(builder);
    }

    public static class Builder {
        private String dateAndTimeOfIssue;
        private String buyerId;
        private String buyerCostCenterId;
        private String invoiceType;
        private String transactionType;
        private String referentDocumentNumber;
        private String referentDocumentDT;
        private BigDecimal advance;
        private BigDecimal advanceTax;
        private Date validTo;
        private boolean copyWithSignature;
        private List<InvoicePayment> payment = new ArrayList<InvoicePayment>();

        private Builder() {
        }

        public Builder withDateAndTimeOfIssue(String time) {
            this.dateAndTimeOfIssue = time;
            return this;
        }

        public Builder withBuyerId(String id) {
            this.buyerId = id;
            return this;
        }

        public Builder withBuyerCostCenterId(String id) {
            this.buyerCostCenterId = id;
            return this;
        }

        public Builder withInvoiceType(String type) {
            this.invoiceType = type;
            return this;
        }

        public Builder withTransactionType(String type) {
            this.transactionType = type;
            return this;
        }

        public Builder withReferentDocumentNumber(String number) {
            this.referentDocumentNumber = number;
            return this;
        }

        public Builder withReferentDocumentDT(String time) {
            this.referentDocumentDT = time;
            return this;
        }

        public Builder withAdvance(BigDecimal advance) {
            this.advance = advance;
            return this;
        }

        public Builder withAdvanceTax(BigDecimal advanceTax) {
            this.advanceTax = advanceTax;
            return this;
        }

        public Builder withValidTo(Date validTo) {
            this.validTo = validTo;
            return this;
        }

        public Builder withCopyWithSignature(boolean copyWithSignature) {
            this.copyWithSignature = copyWithSignature;
            return this;
        }

        public Builder withPayment(String paymentType, BigDecimal amount) {
            InvoicePayment payment = new InvoicePayment();
            payment.setPaymentType(paymentType);
            payment.setAmount(amount);
            this.payment.add(payment);
            return this;
        }

        public Builder withParams(RequestParams params) {
            this.buyerId = params.buyerId;
            this.buyerCostCenterId = params.buyerCostCenterId;
            this.dateAndTimeOfIssue = params.dateAndTimeOfIssue;
            this.invoiceType = params.invoiceType;
            this.payment = params.payment;
            this.referentDocumentNumber = params.referentDocumentNumber;
            this.referentDocumentDT = params.referentDocumentDT;
            this.transactionType = params.transactionType;
            this.validTo = params.validTo;
            return this;
        }

        public RequestParams build() {
            ArrayList<InvoicePayment> payment = new ArrayList<InvoicePayment>();
            for (InvoicePayment p : this.payment) {
                if (BigDecimal.ZERO.compareTo(p.getAmount()) >= 0) continue;
                payment.add(p);
            }
            if (payment.size() == 0) {
                payment.add(new InvoicePayment(BigDecimal.ZERO, "Cash"));
            }
            this.payment = payment;
            return new RequestParams(this, null);
        }
    }
}

