/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.utility;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;

public class BarcodeParser {
    private String tBarkodPrefiks = "28";
    private Integer tBarkodDuzinaSifre = 5;
    private Integer tBarkodDuzinaKolicine = 5;
    private Integer tBarkodBrDecimala = 3;
    private String cBarKodRegex = "S(.+?)C(\\d+.\\d+)";
    private Pattern cBarKodMatcher = Pattern.compile(this.cBarKodRegex);
    public static final int SIFRA = 1;
    public static final int KOLICINA = 2;
    public static final int CENA = 3;

    public void loadSettingsFromDB() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        em.getTransaction().begin();
        this.tBarkodPrefiks = PzParameter.getParameterValue((String)"TBARKOD_PREFIKS", (String)"28", (EntityManager)em);
        this.tBarkodDuzinaSifre = PzParameter.getInteger((String)"TBARKOD_DUZ_SIFRE", (Integer)new Integer(5), (EntityManager)em);
        this.tBarkodDuzinaKolicine = PzParameter.getInteger((String)"TBARKOD_DUZ_KOLIC", (Integer)new Integer(5), (EntityManager)em);
        this.tBarkodBrDecimala = PzParameter.getInteger((String)"TBARKOD_DECIMALE", (Integer)new Integer(3), (EntityManager)em);
        em.getTransaction().commit();
    }

    public boolean isTBarkod(String input) {
        return input.startsWith(this.tBarkodPrefiks) && input.matches("^[0-9]{13}");
    }

    public boolean isCBarkod(String input) {
        return input.matches(this.cBarKodRegex);
    }

    public Object getTValue(String input, int value) {
        int sifraEndPos;
        int prefixLenght;
        int sifraStartPos = prefixLenght = this.tBarkodPrefiks.length();
        int kolStartPos = sifraEndPos = sifraStartPos + this.tBarkodDuzinaSifre;
        int kolEndPos = kolStartPos + this.tBarkodDuzinaKolicine;
        String sifra = input.substring(sifraStartPos, sifraEndPos);
        String kolStr = input.substring(kolStartPos, kolEndPos);
        String kolInt = kolStr.substring(0, kolStr.length() - this.tBarkodBrDecimala);
        String kolDec = kolStr.substring(kolStr.length() - this.tBarkodBrDecimala);
        BigDecimal kolicina = new BigDecimal(String.valueOf(kolInt) + "." + kolDec);
        if (value == 1) {
            return sifra;
        }
        return kolicina;
    }

    public Object getCValue(String input, int value) {
        Matcher m = this.cBarKodMatcher.matcher(input);
        if (!m.find()) {
            return null;
        }
        String sifra = m.group(1);
        String cena = m.group(2);
        if (value == 1) {
            return sifra;
        }
        return Double.valueOf(cena);
    }

    public static void main(String[] args) throws Exception {
        BarcodeParser p = new BarcodeParser();
        String input = "2800137001509";
        System.out.println(p.isTBarkod(input));
        if (p.isTBarkod(input)) {
            System.out.println("Sifra: " + p.getTValue(input, 1));
            System.out.println("Kolicina: " + p.getTValue(input, 2));
        }
        if (p.isCBarkod(input = "S123C12.00")) {
            System.out.println("Sifra: " + p.getCValue(input, 1));
            System.out.println("Cena: " + p.getCValue(input, 3));
        }
    }
}

