/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.utility;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.persistence.EntityManager;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.kasa.lpfr.model.BuyerIdentification;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.rest.LPFRClient;

public class PzKasaService
implements PzGenericService {
    public Object run(Map<Object, Object> parameters) throws Exception {
        PzDokument dok = (PzDokument)parameters.get("DOKUMENT");
        Fiskalniracun r = this.napraviRacun((Faktura)dok);
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)r, true, null, em);
        em.getTransaction().commit();
        LPFRClient client = new LPFRClient();
        client.setTaxMap(PzEntityManager.getList((String)"SELECT t FROM TaxMap t"));
        client.attention();
        client.createInvoice(dok);
        return null;
    }

    private Fiskalniracun napraviRacun(Faktura f) {
        Fiskalniracun r = new Fiskalniracun();
        r.setProizvodfiskalniracuns(new ArrayList());
        r.setTaksafiskalniracuns(new ArrayList());
        r.setTip("FISKALNI_RACUN");
        r.setPodTip(InvoiceTransaction.NORMAL_SALE.getValue());
        r.setKomitent(f.getKomitent());
        r.setVirman(f.getIznos());
        r.setVreme(new Timestamp(new Date().getTime()));
        r.setAdresa(f.getKomitent().getAdresa());
        r.setGrad(f.getKomitent().getGrad());
        r.setIdKupca(BuyerIdentification.PIB_KUPCA.value(f.getKomitent().getPib()));
        r.setIznos(f.getIznos());
        r.setMbr(f.getKomitent().getMatBroj());
        r.setNazivKupca(f.getKomitent().getNaziv());
        r.setPib(f.getKomitent().getPib());
        r.setPzuser(f.getUserKraj());
        r.setRadnajedinica(f.getRadnajedinica());
        r.kopirajArtikleSaFakture(f);
        return r;
    }
}

