/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import rs.pezar.db.PzEntity;
import rs.pezar.reports.util.PzReportUtil;

public class PzDataSource
implements JRDataSource {
    private Vector<PzEntity> data1;
    private int data1Pos;
    private Vector<Iterator<?>> iList;
    private Vector<PzEntity> entities;
    private String className;

    public PzDataSource(Vector<PzEntity> data1, Vector<List<? extends PzEntity>> data2) {
        this.data1 = data1;
        this.data1Pos = 0;
        this.iList = new Vector();
        if (data2 != null) {
            for (List<? extends PzEntity> l : data2) {
                this.iList.addElement(l.iterator());
            }
        } else {
            this.iList.addElement(data1.iterator());
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        String[] array = field.getName().split("_");
        this.className = array[0];
        String classFieldName = array[1];
        System.out.println(field.getName());
        String vElementClass = null;
        if (this.data1.size() > 0 && this.data1Pos < this.data1.size()) {
            for (PzEntity element : this.data1) {
                if (element == null || !(vElementClass = element.getClass().getName().substring(element.getClass().getName().lastIndexOf(".") + 1)).equalsIgnoreCase(this.className)) continue;
                return PzReportUtil.getClassFieldValue(element, classFieldName, this.className);
            }
        }
        return this.getClassFieldValue(this.entities, classFieldName);
    }

    public boolean next() throws JRException {
        boolean result = true;
        this.entities = new Vector();
        for (Iterator<?> i : this.iList) {
            if (!i.hasNext()) continue;
            this.entities.addElement((PzEntity)i.next());
        }
        if (this.entities.size() == 0) {
            result = false;
        } else {
            ++this.data1Pos;
        }
        return result;
    }

    private Object getClassFieldValue(Vector<PzEntity> entities, String fieldName) {
        Object res = null;
        for (PzEntity entity : entities) {
            res = PzReportUtil.getClassFieldValue(entity, fieldName, this.className);
            if (res != null) break;
        }
        return res;
    }
}

