/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.JRProperties;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.reports.PzReportPanel;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzFileExtensionFilter;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.custom.PzDialogEmail;
import rs.pezar.swing.event.PzShortcutListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzFileUtility;

public class PzReportViewer
extends PzDialog {
    private static final long serialVersionUID = 2739457649480959065L;
    private JToolBar toolbar;
    private PzToolBarIcon icnEmail;
    private PzToolBarIcon icnLastPage;
    private PzToolBarIcon icnNextPage;
    private PzToolBarIcon icnPrevPage;
    private PzToolBarIcon icnFirstPage;
    private JSeparator jSeparator2;
    private PzToolBarIcon icnZoomOut;
    private PzToolBarIcon icnZoomIn;
    private JSeparator jSeparator1;
    private PzToolBarIcon icnSave;
    private PzToolBarIcon icnPrint;
    private PzReportPanel viewer;
    private JasperPrint jp;
    private String exportFilename;
    private float zoomRatio = 1.0f;
    private PzToolBarIcon icnOtvori;

    static {
        PzFileUtility.removeDirectory((File)new File(PzApplication.getApplication().getDataFolder() + File.separator + "xls" + File.separator + "tmp"));
        JRProperties.setProperty((String)"net.sf.jasperreports.default.pdf.encoding", (String)"Cp1250");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzReportViewer inst = new PzReportViewer(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzReportViewer(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzReportViewer(PzDialog dialog, JasperPrint jp, String exportFilename) {
        super(dialog);
        this.jp = jp;
        this.exportFilename = exportFilename;
        this.initGUI();
        this.setReportPanel(jp);
    }

    public PzReportViewer(JFrame parent, JasperPrint jp, String exportFilename) {
        super(parent);
        this.jp = jp;
        this.exportFilename = exportFilename;
        this.initGUI();
        this.setReportPanel(jp);
    }

    private PzShortcutListener createShortcutListener() {
        return new PzShortcutListener(){

            public void actionPerformed(PzShortcutListener.PzShortcutEvent evt) {
                if (evt.getShortcut().equals("PAGE_DOWN")) {
                    PzReportViewer.this.viewer.getBtnNext().doClick();
                } else if (evt.getShortcut().equals("PAGE_UP")) {
                    PzReportViewer.this.viewer.getBtnPrevious().doClick();
                } else if (evt.getShortcut().equals("END")) {
                    PzReportViewer.this.viewer.getBtnLast().doClick();
                } else if (evt.getShortcut().equals("HOME")) {
                    PzReportViewer.this.viewer.getBtnFirst().doClick();
                }
            }
        };
    }

    public void setReportPanel(JasperPrint jp) {
        try {
            this.viewer = new PzReportPanel(jp);
            this.getContentPane().add((Component)((Object)this.viewer), "Center");
            this.icnNextPage.addActionListener(this.viewer.getBtnNext().getActionListeners()[0]);
            this.icnPrevPage.addActionListener(this.viewer.getBtnPrevious().getActionListeners()[0]);
            this.icnFirstPage.addActionListener(this.viewer.getBtnFirst().getActionListeners()[0]);
            this.icnLastPage.addActionListener(this.viewer.getBtnLast().getActionListeners()[0]);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.icnPrint = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPrint);
            this.icnPrint.setText("\u0160tampaj|(Alt+s)");
            this.icnPrint.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/printer.png")));
            this.icnPrint.setToolTipText("\u0160tampaj (ALT+S)");
            this.icnPrint.setActionCommand("print");
            this.icnPrint.addActionListener((ActionListener)((Object)this));
            this.icnPrint.setShortcut("alt+s");
            this.icnSave = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSave);
            this.icnSave.setText("Sa\u010duvaj|(Ctrl+s)");
            this.icnSave.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/disks.png")));
            this.icnSave.setToolTipText("Sa\u010duvaj (CTRL+S)");
            this.icnSave.setActionCommand("save");
            this.icnSave.addActionListener((ActionListener)((Object)this));
            this.icnSave.setShortcut("ctrl+s");
            this.icnEmail = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnEmail);
            this.icnEmail.setText("Email|(Ctrl+e)");
            this.icnEmail.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/mail_earth.png")));
            this.icnEmail.setToolTipText("Po\u0161alji kao email (CTRL+E)");
            this.icnEmail.setActionCommand("email");
            this.icnEmail.addActionListener((ActionListener)((Object)this));
            this.icnEmail.setShortcut("ctrl+e");
            this.icnOtvori = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOtvori);
            this.icnOtvori.setText("Otvori kao|(Ctrl+o)");
            this.icnOtvori.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/gear_run.png")));
            this.icnOtvori.setToolTipText("Otvori kroz eksterni program (CTRL+O)");
            this.icnOtvori.setActionCommand("otvori");
            this.icnOtvori.addActionListener((ActionListener)((Object)this));
            this.icnOtvori.setShortcut("ctrl+o");
            this.jSeparator1 = new JSeparator();
            this.toolbar.add(this.jSeparator1);
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setPreferredSize(new Dimension(2, 61));
            this.icnZoomIn = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnZoomIn);
            this.icnZoomIn.setText("Uve\u0107aj (F12)");
            this.icnZoomIn.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/document_zoom_in.png")));
            this.icnZoomIn.setActionCommand("zoom_in");
            this.icnZoomIn.setShortcut("F12");
            this.icnZoomIn.addActionListener((ActionListener)((Object)this));
            this.icnZoomOut = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnZoomOut);
            this.icnZoomOut.setText("Smanji (F11)");
            this.icnZoomOut.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/document_zoom_out.png")));
            this.icnZoomOut.setActionCommand("zoom_out");
            this.icnZoomOut.setShortcut("F11");
            this.icnZoomOut.addActionListener((ActionListener)((Object)this));
            this.jSeparator2 = new JSeparator();
            this.toolbar.add(this.jSeparator2);
            this.jSeparator2.setOrientation(1);
            this.jSeparator2.setPreferredSize(new Dimension(6, 58));
            this.icnFirstPage = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnFirstPage);
            this.icnFirstPage.setText("Prva | (Home)");
            this.icnFirstPage.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/navigate_left2.png")));
            this.icnFirstPage.setActionCommand("first");
            this.icnFirstPage.addActionListener((ActionListener)((Object)this));
            this.icnPrevPage = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPrevPage);
            this.icnPrevPage.setText("Prethodna | (Page Up)");
            this.icnPrevPage.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/navigate_left.png")));
            this.icnPrevPage.setActionCommand("previous");
            this.icnPrevPage.addActionListener((ActionListener)((Object)this));
            this.icnNextPage = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNextPage);
            this.icnNextPage.setText("Slede\u0107a | (Page Down)");
            this.icnNextPage.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/navigate_right.png")));
            this.icnNextPage.setActionCommand("next");
            this.icnNextPage.addActionListener((ActionListener)((Object)this));
            this.icnLastPage = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnLastPage);
            this.icnLastPage.setText("Poslednja | (End)");
            this.icnLastPage.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/reports/img/navigate_right2.png")));
            this.icnLastPage.setActionCommand("last");
            this.icnLastPage.addActionListener((ActionListener)((Object)this));
            this.setShortcutListener(this.createShortcutListener());
            this.registerShortcuts(new String[]{"PAGE_UP", "PAGE_DOWN", "END", "HOME"});
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(850, scrSize.height - 30);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("print")) {
                PzReportViewer.printReport(this.jp);
            } else if (actionCommand.equals("save")) {
                this.saveReport(this.jp);
            } else if (actionCommand.equals("email")) {
                String client = PzParameter.getParameterValue((String)"TIP_MAIL_KLIJENTA", (String)"interni");
                if (client.equals("interni")) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    JasperExportManager.exportReportToPdfStream((JasperPrint)this.jp, (OutputStream)os);
                    PzDialogEmail dialog = new PzDialogEmail((PzDialog)this, os, this.exportFilename, this.exportFilename);
                    dialog.setLocationRelativeTo((Component)((Object)this));
                    dialog.setModal(true);
                    dialog.setVisible(true);
                } else {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String cmd = PzParameter.getParameterValue((String)"MAIL_CLIENT_COMMAND");
                                if (cmd == null || "".equals(cmd)) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)PzReportViewer.this), (String)"Nije definisana komanda za pokretanje mejl klijenta");
                                } else {
                                    String tmpfile = String.valueOf(PzReportViewer.this.getXlsTmpDir()) + File.separator + PzReportViewer.this.exportFilename.replaceAll("\\\\|/|\\-|\\s+|\\:", "_") + ".pdf";
                                    PzReportViewer.this.exportToPdf(PzReportViewer.this.jp, tmpfile);
                                    String[] cmdarr = cmd.replace("$file", tmpfile).replace("$subject", PzReportViewer.this.exportFilename).split("#");
                                    new ProcessBuilder(cmdarr).start();
                                }
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Throwable)e);
                            }
                        }
                    });
                    t.start();
                }
            } else if (actionCommand.equals("otvori")) {
                if (!Desktop.isDesktopSupported()) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Va\u0161 operativni sistem ne podr\u017eava ovu funkciju");
                    return;
                }
                PzChoice[] choices = new PzChoice[]{new PzChoice("PDF Format", (Object)"PDF"), new PzChoice("RTF Format", (Object)"RTF"), new PzChoice("XLS Format", (Object)"XLS"), new PzChoice("ODT Format", (Object)"ODT")};
                String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)this, (PzChoice[])choices, (String)"Izbor formata");
                if (choice == null) {
                    return;
                }
                String tmpfile = String.valueOf(this.getXlsTmpDir()) + File.separator + new SimpleDateFormat("yyyyMMddhhss").format(new Date()) + "." + choice;
                if (choice.equals("PDF")) {
                    this.exportToPdf(this.jp, tmpfile);
                } else if (choice.equals("RTF")) {
                    this.exportToRtf(this.jp, tmpfile);
                } else if (choice.equals("XLS")) {
                    this.exportToXls(this.jp, tmpfile);
                } else if (choice.equals("ODT")) {
                    this.exportToOdt(this.jp, tmpfile);
                } else {
                    return;
                }
                Desktop.getDesktop().open(new File(tmpfile));
            } else if (e.getSource() == this.icnZoomIn) {
                this.zoomRatio = (float)((double)this.zoomRatio + 0.25);
                this.viewer.setZoomRatio(this.zoomRatio);
            } else if (e.getSource() == this.icnZoomOut) {
                this.zoomRatio = (float)((double)this.zoomRatio - 0.25);
                this.viewer.setZoomRatio(this.zoomRatio);
            }
        }
        catch (Exception e1) {
            if (e1 instanceof JRException && e1.getCause() != null && e1.getCause() instanceof PrinterException) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka prilikom \u0161tampanja dokumenta. Proverite da li je \u0161tampa\u010d dobro povezan.");
                return;
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void saveReport(JasperPrint jp) throws JRException, IOException {
        JFileChooser fc = new JFileChooser();
        PzFileExtensionFilter txtFilter = new PzFileExtensionFilter();
        txtFilter.setExtension(".txt");
        txtFilter.setDescription("Text file (.TXT)");
        fc.addChoosableFileFilter((FileFilter)txtFilter);
        PzFileExtensionFilter rtfFilter = new PzFileExtensionFilter();
        rtfFilter.setExtension(".rtf");
        rtfFilter.setDescription("RTF file (.RTF)");
        fc.addChoosableFileFilter((FileFilter)rtfFilter);
        PzFileExtensionFilter odtFilter = new PzFileExtensionFilter();
        odtFilter.setExtension(".odt");
        odtFilter.setDescription("ODT file (.ODT)");
        fc.addChoosableFileFilter((FileFilter)odtFilter);
        PzFileExtensionFilter xlsFilter = new PzFileExtensionFilter();
        xlsFilter.setExtension(".xls");
        xlsFilter.setDescription("Microsoft Excel file (.XLS)");
        fc.addChoosableFileFilter((FileFilter)xlsFilter);
        PzFileExtensionFilter pdfFilter = new PzFileExtensionFilter();
        pdfFilter.setExtension(".pdf");
        pdfFilter.setDescription("PDF file (.PDF)");
        fc.addChoosableFileFilter((FileFilter)pdfFilter);
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            PzFileExtensionFilter selectedFilter = (PzFileExtensionFilter)fc.getFileFilter();
            String file = fc.getSelectedFile().getPath();
            if (!file.endsWith(selectedFilter.getExtension())) {
                file = String.valueOf(file) + selectedFilter.getExtension();
            }
            if (selectedFilter == pdfFilter) {
                this.exportToPdf(jp, file);
            } else if (selectedFilter == xlsFilter) {
                this.exportToXls(jp, file);
            } else if (selectedFilter == txtFilter) {
                this.exportToTxt(jp, file);
            } else if (selectedFilter == rtfFilter) {
                this.exportToRtf(jp, file);
            } else if (selectedFilter == odtFilter) {
                this.exportToOdt(jp, file);
            }
        }
    }

    public static void printReport(JasperPrint jp) throws JRException {
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintRequestAttributeSet aset = null;
        try {
            aset = (PrintRequestAttributeSet)PzApplication.getApplication().getPropManager().loadObject("printdlg.sav");
        }
        catch (Exception e) {
            aset = new HashPrintRequestAttributeSet();
            aset.add(MediaSizeName.ISO_A4);
            aset.add(new MediaPrintableArea(0.17f, 0.17f, MediaSize.ISO.A4.getX(25400), MediaSize.ISO.A4.getY(25400), 25400));
            PzLogger.getInstance().logException((Throwable)e);
        }
        aset.add(new PageRanges(1, jp.getPages().size()));
        aset.add(jp.getOrientationValue() == OrientationEnum.PORTRAIT ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE);
        if (!job.printDialog(aset)) {
            return;
        }
        PrintService service = job.getPrintService();
        PageRanges pr = (PageRanges)aset.get(PageRanges.class);
        int[][] range = pr.getMembers();
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, (Object)aset);
        exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)service.getAttributes());
        int start = range[0][0] - 1;
        int end = range[0][1] - 1;
        exporter.setParameter(JRPrintServiceExporterParameter.START_PAGE_INDEX, (Object)start);
        exporter.setParameter(JRPrintServiceExporterParameter.END_PAGE_INDEX, (Object)end);
        exporter.exportReport();
        try {
            PzApplication.getApplication().getPropManager().saveObject((Object)aset, "printdlg.sav");
        }
        catch (IOException e) {
            PzLogger.getInstance().logException((Throwable)e);
        }
    }

    public static void viewReport(PzDialog parent, JasperPrint jp, String exportFilename) {
        PzReportViewer dlg = new PzReportViewer(parent, jp, exportFilename);
        dlg.setModal(true);
        dlg.restoreSize();
        dlg.setVisible(true);
    }

    public static void viewReport(JFrame parent, JasperPrint jp, String exportFilename) {
        PzReportViewer dlg = new PzReportViewer(parent, jp, exportFilename);
        dlg.setModal(true);
        dlg.restoreSize();
        dlg.setVisible(true);
    }

    public static Object getGUIBuilderInstance() {
        return new PzReportViewer(Boolean.FALSE);
    }

    public PzReportViewer(Boolean initGUI) {
    }

    private void exportToXls(JasperPrint jp, String file) throws JRException, IOException {
        JRXlsExporter exporterXLS = new JRXlsExporter();
        FileOutputStream os = new FileOutputStream(new File(file));
        exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)jp);
        exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)os);
        exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
        exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporterXLS.setParameter(JRXlsExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
        exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)Boolean.TRUE);
        exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporterXLS.exportReport();
        ((OutputStream)os).close();
    }

    private void exportToPdf(JasperPrint jp, String file) throws JRException, IOException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)jp, (String)file);
    }

    private void exportToTxt(JasperPrint jp, String file) throws JRException, IOException {
        JRTextExporter exporterTXT = new JRTextExporter();
        FileOutputStream os = new FileOutputStream(new File(file));
        exporterTXT.setParameter(JRTextExporterParameter.JASPER_PRINT, (Object)jp);
        exporterTXT.setParameter(JRTextExporterParameter.OUTPUT_STREAM, (Object)os);
        exporterTXT.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)Float.valueOf(20.0f));
        exporterTXT.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)Float.valueOf(5.0f));
        exporterTXT.setParameter(JRTextExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        exporterTXT.exportReport();
        ((OutputStream)os).close();
    }

    private void exportToRtf(JasperPrint jp, String file) throws JRException, IOException {
        JRRtfExporter exporterRTF = new JRRtfExporter();
        FileOutputStream os = new FileOutputStream(new File(file));
        exporterRTF.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporterRTF.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
        exporterRTF.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        exporterRTF.exportReport();
        ((OutputStream)os).close();
    }

    private void exportToOdt(JasperPrint jp, String file) throws JRException, IOException {
        JROdtExporter exporterRTF = new JROdtExporter();
        FileOutputStream os = new FileOutputStream(new File(file));
        exporterRTF.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        exporterRTF.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
        exporterRTF.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        exporterRTF.exportReport();
        ((OutputStream)os).close();
    }

    public String getXlsTmpDir() {
        String path = PzApplication.getApplication().getDataFolder() + File.separator + "xls";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = new File(path = PzApplication.getApplication().getDataFolder() + File.separator + "xls" + File.separator + "tmp")).exists()) {
            file.mkdir();
        }
        return String.valueOf(path) + File.separator;
    }
}

