/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.util.Vector;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntity;
import rs.pezar.reports.util.PzReportUtil;
import rs.pezar.util.StopWatch;

public class PzScrollableDataSource
implements JRDataSource {
    private ScrollableCursor cursor;
    private Vector<? extends PzEntity> eData;
    private Object[] current;
    private JProgressBar progress;
    private StopWatch timer;
    private int i = 0;
    private int size;
    private SwingWorker<JasperPrint, Integer> sw;

    public PzScrollableDataSource(ScrollableCursor cursor, Vector<? extends PzEntity> externalData, JProgressBar progress) {
        this.cursor = cursor;
        this.cursor.absolute(this.i);
        this.size = cursor.size();
        this.eData = externalData;
        this.progress = progress;
        if (progress != null && cursor != null) {
            progress.setIndeterminate(false);
            progress.setMinimum(0);
            progress.setMaximum(this.size - 1);
        }
        this.timer = new StopWatch();
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object result = null;
        try {
            if (field.getName().indexOf("_") != -1) {
                String className = field.getName().split("_")[0];
                result = this.getClassFieldValue(this.eData, field.getName().split("_")[1], className);
            } else {
                int colNum = Integer.parseInt(field.getName().substring(1));
                result = this.current[colNum];
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Naziv polja nije dobar. Polje: [" + field.getName() + "]. Naziv pocinje znakom f i ima uz sebe numericku oznaku kolone (pr. f1, f2, f3 ...)");
        }
        return result;
    }

    public boolean next() throws JRException {
        boolean hasnext = this.cursor.hasNext();
        if (this.i < this.size) {
            if (this.progress != null) {
                this.progress.setValue(this.cursor.getPosition());
            }
            this.cursor.absolute(this.i);
            this.current = (Object[])this.cursor.next();
            ++this.i;
        }
        return hasnext;
    }

    private Object getClassFieldValue(Vector<? extends PzEntity> entities, String fieldName, String className) {
        Object res = null;
        for (PzEntity pzEntity : entities) {
            res = PzReportUtil.getClassFieldValue(pzEntity, fieldName, className);
            if (res != null) break;
        }
        return res;
    }
}

