/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.util.Vector;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import rs.pezar.db.PzEntity;
import rs.pezar.reports.util.PzReportUtil;
import rs.pezar.swing.PzAbstractTable;

public class PzTableDataSource
implements JRDataSource {
    private TableModel model;
    private Vector<? extends PzEntity> eData;
    private int row;

    public PzTableDataSource(PzAbstractTable table, Vector<? extends PzEntity> externalData) {
        this.model = table.getModel();
        this.eData = externalData;
        this.row = -1;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object result = null;
        try {
            if (field.getName().indexOf("_") != -1) {
                String className = field.getName().split("_")[0];
                result = this.getClassFieldValue(this.eData, field.getName().split("_")[1], className);
            } else {
                int colNum = Integer.parseInt(field.getName().substring(1));
                result = this.model.getValueAt(this.row, colNum);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Naziv polja nije dobar. Polje: [" + field.getName() + "]. Naziv pocinje znakom f i ima uz sebe numericku oznaku kolone (pr. f1, f2, f3 ...)");
        }
        return result;
    }

    public boolean next() throws JRException {
        ++this.row;
        int rowCount = this.model.getRowCount();
        if (this.eData.size() > 0 && this.row == 0) {
            ++rowCount;
        }
        return rowCount > this.row;
    }

    private Object getClassFieldValue(Vector<? extends PzEntity> entities, String fieldName, String className) {
        Object res = null;
        for (PzEntity pzEntity : entities) {
            res = PzReportUtil.getClassFieldValue(pzEntity, fieldName, className);
            if (res != null) break;
        }
        return res;
    }
}

