/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.rf;

import java.awt.Component;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzSingleListDataSource;
import rs.pezar.reports.engine.dokument.DokumentDS;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.reports.rf.PzDokumentRF;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzFileUtility;

public class NivelacijaCursorRF
extends PzDokumentRF {
    private EntityManager em;
    private ScrollableCursor cursor;

    @Override
    public void showReport(final PzDialog parent, final PzDokument dokument) {
        if (dokument.getPodTip().equals(TipDokumentConfig.get().PODTIP_NIVELACIJA_VREDNOSNA)) {
            try {
                PzReportManager.createAndShowReport(parent, dokument, "Nivelacija broj " + dokument.getrBroj(), null);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
            }
        } else if (dokument.getRadnajedinica().getgTip().equals("V") || dokument.getRadnajedinica().getgTip().equals("T")) {
            this.em = PzEntityManagerFactory.getInstance().createEm();
            Query q = this.em.createQuery("SELECT an FROM Artikalnivelacija an WHERE an.id.idDok = " + dokument.getIdDok() + " ORDER BY an.id.rBroj ASC");
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            q.setHint("eclipselink.read-only", (Object)"True");
            this.cursor = (ScrollableCursor)q.getSingleResult();
            Vector<Object> sContent = new Vector<Object>();
            sContent.add(dokument);
            PzDataSourceExtended ds = new PzDataSourceExtended(sContent, this.cursor);
            ds.setAdapter(new PzBeanDataSourceAdapter());
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("headerStandardSubreport", (JasperReport)JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.standard.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
                params.put("headerData", new DokumentDS(dokument));
                params.put("title", "Nivelacija broj " + dokument.getrBroj());
                PzReportManager.createAndShowReport(parent, (JRDataSource)ds, this.getClass().getClassLoader().getResource("rs/pezar/reports/compiled/nivelacija.cursor.v.jasper"), params, "nivelacija_" + dokument.getrBroj(), this, PzReportManager.REPORT_TYPE_JASPER);
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
            }
        } else {
            PzWorkerDialog.showStatus((String)"Dobavljanje podataka je u toku ...", (PzDialog)parent);
            SwingWorker<PzDataSourceExtended, Object> worker = new SwingWorker<PzDataSourceExtended, Object>(){

                @Override
                protected PzDataSourceExtended doInBackground() throws Exception {
                    NivelacijaCursorRF.this.em = PzEntityManagerFactory.getInstance().createEm();
                    Query q = NivelacijaCursorRF.this.em.createQuery("SELECT an.id.sfrProizvod, an.naziv, t.stopa, an.kolicina, an.cenaStara, an.cenaNova FROM Artikalnivelacija an JOIN an.antaksas t WHERE t.oznVrstaTG='PDV' AND an.id.idDok = " + dokument.getIdDok());
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    NivelacijaCursorRF.this.cursor = (ScrollableCursor)q.getSingleResult();
                    Vector<Object> sContent = new Vector<Object>();
                    sContent.add(dokument);
                    PzDataSourceExtended ds = new PzDataSourceExtended(sContent, NivelacijaCursorRF.this.cursor);
                    ds.setAdapter(new PzResultSetDataSourceAdapter());
                    return ds;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put("headerStandardSubreport", (JasperReport)JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.standard.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
                            params.put("headerData", new DokumentDS(dokument));
                            params.put("title", "Nivelacija broj " + dokument.getrBroj());
                            params.put("porezSubreport", (JasperReport)JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.tbl.bigdecimal.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
                            params.put("porezDS", new PzSingleListDataSource(((Nivelacija)dokument).getTaksanivelacijas()));
                            PzDataSourceExtended ds = (PzDataSourceExtended)this.get();
                            PzReportManager.createAndShowReport(parent, (JRDataSource)ds, this.getClass().getClassLoader().getResource("rs/pezar/reports/compiled/nivelacija.cursor.m.jasper"), params, "nivelacija_" + dokument.getrBroj(), NivelacijaCursorRF.this, PzReportManager.REPORT_TYPE_JASPER);
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }

    @Override
    public void finish() {
        this.cursor.close();
        this.em.close();
    }
}

