/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.gui.frames;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import rs.pezar.creator.cmdParsing.CmdParams;
import rs.pezar.creator.cmdParsing.CmdParser;
import rs.pezar.creator.gui.panelManager.PzManagedFrame;
import rs.pezar.creator.gui.panels.Izvestaj1;
import rs.pezar.creator.gui.panels.IzvestajMigracija;
import rs.pezar.creator.gui.panels.MigracijaFolder;
import rs.pezar.creator.gui.panels.PnlIzbor;
import rs.pezar.creator.gui.panels.PnlKonekcija;
import rs.pezar.creator.gui.panels.PnlNazivBaze;
import rs.pezar.creator.gui.panels.PnlNazivBazePocetno;
import rs.pezar.creator.gui.panels.PnlPocetnoStanje;
import rs.pezar.creator.gui.panels.PnlUveziSql;
import rs.pezar.creator.gui.panels.PnlUveziSqlPocetno;
import rs.pezar.creator.gui.panels.Settings;
import rs.pezar.creator.gui.panels.izvestaj.DialogAlocKolicine;
import rs.pezar.creator.tools.Db.DbTools;
import rs.pezar.creator.tools.DbConnector;
import rs.pezar.creator.tools.migration.MigrationExecuter;

public class PzMain {
    private PzManagedFrame manager = new PzManagedFrame("img/worked1.jpg", "PzCreator - kreiranje radne baze podataka"){

        @Override
        public void OnKrajPressed() {
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    String opcija = ((PnlIzbor)PzMain.this.manager.getPanels().get(0)).getSelectedOption();
                    if (opcija.equals(PnlIzbor.option1)) {
                        ((Izvestaj1)PzMain.this.manager.getPanel("IZVESTAJ1")).printTime();
                        PzMain.this.manager.hideEndButton(true);
                        return PzMain.this.kreirajPraznuBazu();
                    }
                    if (opcija.equals(PnlIzbor.option2)) {
                        PzMain.this.manager.hideEndButton(true);
                        boolean kopiraj = true;
                        boolean pocetno = true;
                        if (((PnlUveziSqlPocetno)PzMain.this.manager.getPanel("UVEZI_SQL_POCETNO")).isEnabled()) {
                            kopiraj = PzMain.this.kopirajSifarnike();
                        }
                        pocetno = PzMain.this.kopirajPoctnoStanje();
                        if (kopiraj && pocetno) {
                            return true;
                        }
                        return false;
                    }
                    if (opcija.equals(PnlIzbor.option3)) {
                        PzMain.this.manager.hideEndButton(true);
                        return PzMain.this.Migracija();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    PzMain.this.manager.hideEndButton(false);
                    Boolean success = true;
                    try {
                        success = (Boolean)this.get();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    if (success == null) {
                        return;
                    }
                    if (success.booleanValue()) {
                        JOptionPane.showMessageDialog(PzMain.this.manager, "Gotovo!");
                        int answer = JOptionPane.showConfirmDialog(PzMain.this.manager, "Po\u010deti ponovo?", "Restart", 0);
                        if (answer == 0) {
                            PzMain.this.manager.restart();
                        }
                    } else {
                        JOptionPane.showMessageDialog(PzMain.this.manager, "Postoje gre\u0161ke! Pogledaj izve\u0161taj za info!", "Gre\u0161ka", 0);
                    }
                    super.done();
                }
            };
            worker.execute();
        }
    };

    public PzMain(CmdParams cmdParams) {
        PnlIzbor izbor = new PnlIzbor();
        this.manager.addPanel(izbor);
        this.manager.addPanel(new PnlNazivBaze());
        this.manager.addPanel(new PnlKonekcija());
        PnlKonekcija pnlPocetnoStanjeKonekcija = new PnlKonekcija(Settings.TYPE_POCETNO_STANJE, "KONEKCIJA_POCETNO_STANJE");
        this.manager.addPanel(pnlPocetnoStanjeKonekcija);
        this.manager.addPanel(new PnlUveziSql("novaBaza"));
        this.manager.addPanel(new Izvestaj1(Settings.TYPE_NOVA_BAZA, "IZVESTAJ1"));
        this.manager.addPanel(new PnlKonekcija(Settings.TYPE_MIGRACIJA, "KONEKCIJA_MIGRACIJA"));
        this.manager.addPanel(new MigracijaFolder());
        this.manager.addPanel(new IzvestajMigracija(Settings.TYPE_MIGRACIJA, "IZVESTAJ_MIGRACIJA"));
        PnlNazivBazePocetno nazivBazePocetno = new PnlNazivBazePocetno();
        this.manager.addPanel(nazivBazePocetno);
        this.manager.addPanel(new PnlUveziSqlPocetno("pocetnoStanje"));
        this.manager.addPanel(new PnlPocetnoStanje());
        this.manager.addPanel(new Izvestaj1(Settings.TYPE_POCETNO_STANJE, "IZVESTAJ_POCETNO_STANJE"));
        if (cmdParams != null) {
            if (cmdParams.getType() != null && cmdParams.getType().equals(CmdParser.CMD_TYPE_NEW_YEAR)) {
                izbor.setSelectedOption(PnlIzbor.option2);
            }
            if (cmdParams.getSourceDb() != null && cmdParams.getSourceDb().size() > 0) {
                int j = 0;
                while (j < cmdParams.getSourceDb().size()) {
                    nazivBazePocetno.addDataPair(cmdParams.getSourceDb().get(j), cmdParams.getTargetDb().get(j));
                    ++j;
                }
            }
            if (cmdParams.getServerAddress() != null && cmdParams.getServerAddress().length() > 0) {
                pnlPocetnoStanjeKonekcija.setHost(cmdParams.getServerAddress());
            }
        }
        this.manager.showMenu();
    }

    private Boolean kreirajPraznuBazu() {
        String driver = ((PnlKonekcija)this.manager.getPanels().get(2)).getSelectedItem().getDriver();
        String protocol = ((PnlKonekcija)this.manager.getPanels().get(2)).getSelectedItem().getProtocol();
        String host = ((PnlKonekcija)this.manager.getPanels().get(2)).getTxtHost().getText();
        String user = ((PnlKonekcija)this.manager.getPanels().get(2)).getTxtUser().getText();
        String pass = ((PnlKonekcija)this.manager.getPanels().get(2)).getTxtPass().getText();
        Vector<String> dbNames = ((PnlNazivBaze)this.manager.getPanel("NAZIV_BAZE")).getBaseNames();
        int i = 0;
        while (i < dbNames.size()) {
            String dbName = dbNames.get(i);
            if (DbTools.databaseExists(driver, protocol, host, user, pass, dbName)) {
                ((Izvestaj1)this.manager.getPanel("IZVESTAJ1")).addInfo("Kreiranje baze [" + dbName + "]", "ERROR: Database already exists!");
                return false;
            }
            try {
                DbTools.createDatabase(driver, protocol, host, user, pass, dbName);
            }
            catch (Exception e) {
                e.printStackTrace();
                ((Izvestaj1)this.manager.getPanel("IZVESTAJ1")).addInfo("Kreiranje baze [" + dbName + "]", e.getMessage());
                return false;
            }
            ((Izvestaj1)this.manager.getPanel("IZVESTAJ1")).addInfo("Kreiranje baze [" + dbName + "]", "OK!");
            Vector<String> scripts = ((PnlUveziSql)this.manager.getPanel("UVEZISQL")).getSortedListOfNames();
            for (String string : scripts) {
                try {
                    DbTools.runScript(driver, protocol, host, user, pass, dbName, string);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((Izvestaj1)this.manager.getPanel("IZVESTAJ1")).addInfo(String.valueOf(string) + " [" + dbName + "]", e.getMessage());
                    return false;
                }
                ((Izvestaj1)this.manager.getPanel("IZVESTAJ1")).addInfo(String.valueOf(string) + " [" + dbName + "]", "OK!");
            }
            ++i;
        }
        return true;
    }

    private boolean kopirajSifarnike() {
        String driver = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getSelectedItem().getDriver();
        String protocol = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getSelectedItem().getProtocol();
        String host = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getTxtHost().getText();
        String user = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getTxtUser().getText();
        String pass = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getTxtPass().getText();
        Vector<String[]> dbNames = ((PnlNazivBazePocetno)this.manager.getPanel("NAZIV_BAZE_POCETNO")).getNamePairs();
        Vector<String> tablenames = ((PnlUveziSqlPocetno)this.manager.getPanel("UVEZI_SQL_POCETNO")).getTablenames();
        int i = 0;
        while (i < dbNames.size()) {
            String sourcename = dbNames.get(i)[0];
            String destinationname = dbNames.get(i)[1];
            int j = tablenames.size() - 1;
            while (j >= 0) {
                if (!tablenames.get(j).startsWith("sql=")) {
                    try {
                        DbTools.deleteDataFromTable(driver, protocol, host, user, pass, destinationname, tablenames.get(j));
                    }
                    catch (Exception e) {
                        String message = "";
                        if (e instanceof SQLException && ((SQLException)e).getNextException() != null) {
                            message = ((SQLException)e).getNextException().getMessage();
                        }
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje [" + destinationname + "." + tablenames.get(j) + "]", String.valueOf(e.getMessage()) + message);
                        e.printStackTrace();
                        return false;
                    }
                    ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje [" + destinationname + "." + tablenames.get(j) + "]", "OK!");
                }
                --j;
            }
            j = 0;
            while (j < tablenames.size()) {
                if (tablenames.get(j).startsWith("sql=")) {
                    String sqlName = tablenames.get(j).substring(4, tablenames.get(j).length());
                    try {
                        DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/" + sqlName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("SQL : " + sqlName + " error ", e.getMessage());
                    }
                    ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("SQL : " + sqlName, "OK!");
                } else {
                    try {
                        DbTools.copyTable(driver, protocol, host, user, pass, sourcename, tablenames.get(j), destinationname, tablenames.get(j));
                    }
                    catch (Exception e) {
                        String message = "";
                        if (e instanceof SQLException && ((SQLException)e).getNextException() != null) {
                            message = ((SQLException)e).getNextException().getMessage();
                        }
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Kopiranje :" + sourcename + "." + tablenames.get(j) + " -> " + destinationname + "." + tablenames.get(j), String.valueOf(e.getMessage()) + message);
                        e.printStackTrace();
                        return false;
                    }
                    ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Kopiranje :" + sourcename + "." + tablenames.get(j) + " -> " + destinationname + "." + tablenames.get(j), "OK!");
                }
                ++j;
            }
            j = 0;
            while (j < tablenames.size()) {
                if (!tablenames.get(j).startsWith("sql=")) {
                    Integer row;
                    try {
                        row = DbTools.checkHashes(driver, protocol, host, user, pass, sourcename, tablenames.get(j), destinationname, tablenames.get(j));
                    }
                    catch (Exception e) {
                        String message = "";
                        if (e instanceof SQLException && ((SQLException)e).getNextException() != null) {
                            message = ((SQLException)e).getNextException().getMessage();
                        }
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Test :" + sourcename + "." + tablenames.get(j), String.valueOf(e.getMessage()) + message);
                        e.printStackTrace();
                        return false;
                    }
                    if (row != 0) {
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Test :" + sourcename + "." + tablenames.get(j) + " -> " + destinationname + "." + tablenames.get(j), "Greska u redu broj :" + String.valueOf(row) + "Ovo je ok ako je tabela menjana posle kopiranja!");
                    } else {
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Test :" + sourcename + "." + tablenames.get(j) + " -> " + destinationname + "." + tablenames.get(j), "OK!");
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean kopirajPoctnoStanje() {
        String driver = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getSelectedItem().getDriver();
        String protocol = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getSelectedItem().getProtocol();
        String host = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getTxtHost().getText();
        String user = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getTxtUser().getText();
        String pass = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_POCETNO_STANJE")).getTxtPass().getText();
        Vector<String[]> dbNames = ((PnlNazivBazePocetno)this.manager.getPanel("NAZIV_BAZE_POCETNO")).getNamePairs();
        Vector<String> tablenames = ((PnlUveziSqlPocetno)this.manager.getPanel("UVEZI_SQL_POCETNO")).getTablenames();
        int i = 0;
        while (i < dbNames.size()) {
            block11: {
                String destinationname;
                String sourcename;
                block12: {
                    sourcename = dbNames.get(i)[0];
                    destinationname = dbNames.get(i)[1];
                    try {
                        String queryToBeUsed;
                        Integer id;
                        if (((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(0)) {
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje", "Kupci");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoKupciFaktura.sql");
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje pocetnog " + destinationname + ".[faktura]", "OK!");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoKupciDokument.sql");
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje pocetnog " + destinationname + ".[dokument]", "OK!");
                            id = DbTools.getid(driver, protocol, host, user, pass, destinationname);
                            id = id + 1;
                            queryToBeUsed = ((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(4) ? PnlPocetnoStanje.readFile("pocetnoStanje/pocetnoKupciGrupno.sql") : PnlPocetnoStanje.readFile("pocetnoStanje/pocetnoKupciPojedinacno.sql");
                            id = DbTools.copyPocetnoStanjeKupci(driver, protocol, host, user, pass, sourcename, destinationname, queryToBeUsed, id);
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje " + sourcename + ".[dokument,faktura]->" + destinationname + ".[dokument,faktura]", "OK!");
                            DbTools.updateid(driver, protocol, host, user, pass, destinationname, id);
                        }
                        if (((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(1)) {
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje", "Dobavljaci");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoDobavljaciKalkulacija.sql");
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje pocetnog " + destinationname + ".[kalkulacija]", "OK!");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoDobavljaciDokument.sql");
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje pocetnog " + destinationname + ".[dokument]", "OK!");
                            id = DbTools.getid(driver, protocol, host, user, pass, destinationname);
                            id = id + 1;
                            queryToBeUsed = ((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(4) ? PnlPocetnoStanje.readFile("pocetnoStanje/pocetnoDobavljaciGrupno.sql") : PnlPocetnoStanje.readFile("pocetnoStanje/pocetnoDobavljaciPojedinacno.sql");
                            id = DbTools.copyPocetnoStanjeDobavljaci(driver, protocol, host, user, pass, sourcename, destinationname, queryToBeUsed, id);
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje " + sourcename + ".[dokument,kalkulacija] ->" + destinationname + ".[dokument,kalkulacija]", "OK!");
                            DbTools.updateid(driver, protocol, host, user, pass, destinationname, id);
                        }
                        if (((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(2)) {
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje avansa", "Kupci");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiKupaca1.sql");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiKupaca2.sql");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiKupaca3.sql");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiKupaca4.sql");
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje pocetnog stanja avansa kupaca", "OK!");
                            id = DbTools.getid(driver, protocol, host, user, pass, destinationname);
                            id = id + 1;
                            id = DbTools.copyAvansiToAnotherTable(driver, protocol, host, user, pass, sourcename, destinationname, ((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getPocetnoAvansiKupaca(), "kupac", id, ((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getYear());
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje " + sourcename + ".[dokument]" + destinationname + ".[dokument]", "OK!");
                            DbTools.updateid(driver, protocol, host, user, pass, destinationname, id);
                        }
                        if (((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(6)) {
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje", "Nefakturisana roba");
                            id = DbTools.getid(driver, protocol, host, user, pass, destinationname);
                            id = id + 1;
                            queryToBeUsed = PnlPocetnoStanje.readFile("pocetnoStanje/PocetnoNefakturisanaPojedinacno.sql");
                            id = DbTools.copyPocetnoStanjeDobavljaci(driver, protocol, host, user, pass, sourcename, destinationname, queryToBeUsed, id);
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje " + sourcename + ".[dokument,kalkulacija] ->" + destinationname + ".[dokument,kalkulacija]", "OK!");
                            DbTools.updateid(driver, protocol, host, user, pass, destinationname, id);
                        }
                        if (((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(3)) {
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje avansa", "Dobavljaci");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiDobavljaca1.sql");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiDobavljaca2.sql");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiDobavljaca3.sql");
                            DbTools.runScript(driver, protocol, host, user, pass, destinationname, "pocetnoStanje/brisiPocetnoAvansiDobavljaca4.sql");
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Brisanje pocetnog stanja avansa dobavljaca", "OK!");
                            id = DbTools.getid(driver, protocol, host, user, pass, destinationname);
                            id = DbTools.copyAvansiToAnotherTable(driver, protocol, host, user, pass, sourcename, destinationname, ((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getPocetnoAvansiDobavljaca(), "dobavljac", id, ((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getYear());
                            ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje " + sourcename + ".[dokument]" + destinationname + ".[dokument]", "OK!");
                            DbTools.updateid(driver, protocol, host, user, pass, destinationname, id);
                        }
                        if (!((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(5)) break block11;
                        Vector<String> aloc = DbTools.getAlocKolicine(driver, protocol, host, user, pass, sourcename);
                        if (aloc == null) break block12;
                        DialogAlocKolicine.showAlocirane(this.manager.getPanel("POCETNO"), aloc);
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje robe", "GRESKA, postoje alocirane kolicine!");
                        Object[] options = new Object[]{"Da", "Ne"};
                        int rez = JOptionPane.showOptionDialog((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE"), "Nastavljas sa alociranim kolicinama?", "Postoje alocirane kolicine", 0, 3, null, options, true);
                        if (rez != 1) break block12;
                        return false;
                    }
                    catch (Exception e) {
                        ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje " + destinationname, e.getMessage());
                        e.printStackTrace();
                        return false;
                    }
                }
                if (((PnlPocetnoStanje)this.manager.getPanel("POCETNO")).getState(7)) {
                    DbTools.copyPocetnoStajneRobeOnlyExisting(driver, protocol, host, user, pass, sourcename, destinationname);
                } else {
                    DbTools.copyPocetnoStajneRobe(driver, protocol, host, user, pass, sourcename, destinationname);
                }
                ((Izvestaj1)this.manager.getPanel("IZVESTAJ_POCETNO_STANJE")).addInfo("Pocetno stanje robe iz [" + sourcename + "] u [" + destinationname + "]", "OK!");
            }
            ++i;
        }
        return true;
    }

    private Boolean Migracija() {
        String driver = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_MIGRACIJA")).getSelectedItem().getDriver();
        String protocol = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_MIGRACIJA")).getSelectedItem().getProtocol();
        String host = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_MIGRACIJA")).getTxtHost().getText();
        String user = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_MIGRACIJA")).getTxtUser().getText();
        String pass = ((PnlKonekcija)this.manager.getPanel("KONEKCIJA_MIGRACIJA")).getTxtPass().getText();
        String folder = ((MigracijaFolder)this.manager.getPanel("MIGRACIJA_FOLDER")).getFolder();
        String sufiks = ((MigracijaFolder)this.manager.getPanel("MIGRACIJA_FOLDER")).getSufiks();
        String baza = ((MigracijaFolder)this.manager.getPanel("MIGRACIJA_FOLDER")).getBaza();
        IzvestajMigracija izvestajMigracija = (IzvestajMigracija)this.manager.getPanel("IZVESTAJ_MIGRACIJA");
        try {
            String opt = protocol.equals("postgresql") ? "/postgres" : "";
            Connection conn = DbConnector.OpenConnection(driver, "jdbc:" + protocol + "://" + host + "/" + baza, user, pass);
            MigrationExecuter m = new MigrationExecuter(folder, sufiks, izvestajMigracija, conn, MigrationExecuter.OUTPUT_TO_DATABASE, null);
            m.start();
        }
        catch (SQLException e) {
            izvestajMigracija.addInfo("Migracija neuspesna!\nEXCEPTION: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        try {
            izvestajMigracija.getWait().acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return izvestajMigracija.isSuccess();
    }
}

