/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.migration;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import rs.pezar.creator.tools.functions.Function;
import rs.pezar.creator.tools.migration.Field;
import rs.pezar.creator.tools.migration.MigrationExecuter;
import rs.pezar.creator.tools.migration.MigrationMap;
import rs.pezar.creator.tools.xml.XmlParser;

public class MigrationUtil {
    public static Object formatValue(Field f) throws Exception {
        if (f.getDefaultValue() != null) {
            if (f.getDefaultValue().startsWith("$FUN(")) {
                return MigrationUtil.executeFunction(f, f.getDefaultValue());
            }
            if (f.getConversion() != null) {
                return f.getConversion().convert(f.getDefaultValue().trim());
            }
            return "'" + f.getDefaultValue().trim().replace("'", "''").replace("\\", "\\\\") + "'";
        }
        if (f.getConversion() != null) {
            return f.getConversion().convert(f.getDbfField().get().trim());
        }
        return "'" + f.getDbfField().get().trim().replace("'", "''").replace("\\", "\\\\") + "'";
    }

    private static Object executeFunction(Field f, String funName) throws Exception {
        String function = funName.replace("$FUN(", "").replace(")", "");
        String[] arr = function.split(",", 2);
        String fname = arr[0];
        Function fun = (Function)Class.forName("rs.pezar.creator.tools.functions." + fname).newInstance();
        return fun.execute(f, arr.length > 1 ? arr[1] : null);
    }

    public static Vector<MigrationMap> loadMigrationMaps(String yy) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] migrationFileNames = MigrationUtil.loadMigrationMapsFileNames();
        Vector<MigrationMap> maps = new Vector<MigrationMap>();
        MigrationMap m = null;
        int i = 0;
        while (i < migrationFileNames.length) {
            Document d = MigrationUtil.loadMigrationMap(migrationFileNames[i]);
            m = new MigrationMap();
            m.load(d, yy);
            maps.addElement(m);
            ++i;
        }
        return maps;
    }

    private static Document loadMigrationMap(String string) throws IOException, ParserConfigurationException, SAXException {
        return XmlParser.loadXmlAsString(String.valueOf(MigrationExecuter.MIGRATIONS_DIR) + "/" + string);
    }

    private static String[] loadMigrationMapsFileNames() throws IOException, ParserConfigurationException, SAXException {
        Document d = XmlParser.loadXML(MigrationExecuter.CONF_FILE);
        NodeList migrationsList = d.getElementsByTagName("migration");
        String[] res = new String[migrationsList.getLength()];
        int i = 0;
        while (i < migrationsList.getLength()) {
            res[i] = migrationsList.item(i).getAttributes().getNamedItem("file").getNodeValue();
            ++i;
        }
        return res;
    }

    public static boolean checkCondition(MigrationMap t) throws Exception {
        if (t.getCondition() == null || t.getCondition().equals("")) {
            return true;
        }
        if (t.getCondition().startsWith("$FUN(")) {
            return (Boolean)MigrationUtil.executeFunction(t.getFields().get(0), t.getCondition());
        }
        String dbfName = t.getCondition().split("=")[0];
        String dbfValue = t.getCondition().split("=")[1];
        Field f = t.getFieldDbfNamed(dbfName);
        return MigrationUtil.formatValue(f).equals(dbfValue);
    }
}

