/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.migration.migrators;

import org.xBaseJ.DBF;
import rs.pezar.creator.tools.migration.Field;
import rs.pezar.creator.tools.migration.KeyStore;
import rs.pezar.creator.tools.migration.MigrationExecuter;
import rs.pezar.creator.tools.migration.MigrationMap;
import rs.pezar.creator.tools.migration.MigrationUtil;
import rs.pezar.creator.tools.migration.migrators.Migrator;
import rs.pezar.creator.tools.migration.progress.MigrationMonitor;

public class DefaultMigrator
implements Migrator {
    private KeyStore keyStore;

    @Override
    public void migerate(DBF dbfTable, MigrationMap t, String values, String fnames, MigrationMonitor monitor, MigrationExecuter executer) throws Exception {
        this.keyStore = new KeyStore();
        String pkName = "";
        int fc = 0;
        while (fc < t.getFields().size()) {
            if (t.getFields().elementAt(fc).getDbfName() != null) {
                org.xBaseJ.fields.Field dbfField = dbfTable.getField(t.getFields().elementAt(fc).getDbfName());
                t.getFields().elementAt(fc).setDbfField(dbfField);
            }
            if (t.getFields().elementAt(fc).getType() != null && t.getFields().elementAt(fc).getType().startsWith("pk")) {
                pkName = String.valueOf(pkName) + (!pkName.equals("") ? "+" : "") + t.getFields().elementAt(fc).getSqlName();
            }
            ++fc;
        }
        this.keyStore.createStore(pkName);
        System.out.println("Key store created for field " + pkName);
        int rc = 1;
        while (rc <= dbfTable.getRecordCount()) {
            boolean ok = true;
            dbfTable.read();
            if (!dbfTable.deleted() && MigrationUtil.checkCondition(t)) {
                values = "";
                fnames = "";
                String pkValue = "";
                int fc2 = 0;
                while (fc2 < t.getFields().size()) {
                    if (t.getFields().elementAt(fc2).getType() != null && t.getFields().elementAt(fc2).getType().startsWith("pk")) {
                        pkValue = String.valueOf(pkValue) + MigrationUtil.formatValue(t.getFields().elementAt(fc2));
                    }
                    if (t.getFields().elementAt(fc2).getType() != null && t.getFields().elementAt(fc2).getType().equals("pk_noempty") && this.pkEmpty(t.getFields().elementAt(fc2))) {
                        ok = false;
                    }
                    if (t.getFields().elementAt(fc2).getDepends() != null) {
                        Field depf;
                        if (t.getFieldSqlNamed(t.getFields().elementAt(fc2).getDepends()) != null && MigrationUtil.formatValue(depf = t.getFieldSqlNamed(t.getFields().elementAt(fc2).getDepends())) != null) {
                            fnames = String.valueOf(fnames) + (fc2 > 0 ? "," : "") + t.getFields().elementAt(fc2).getSqlName();
                            values = String.valueOf(values) + (fc2 > 0 ? "," : "") + MigrationUtil.formatValue(t.getFields().elementAt(fc2));
                        }
                    } else {
                        fnames = String.valueOf(fnames) + (fc2 > 0 ? "," : "") + t.getFields().elementAt(fc2).getSqlName();
                        values = String.valueOf(values) + (fc2 > 0 ? "," : "") + MigrationUtil.formatValue(t.getFields().elementAt(fc2));
                    }
                    ++fc2;
                }
                if (pkValue.trim().equals("") && !pkName.equals("")) {
                    ok = false;
                }
                if (this.pkExists(pkName, pkValue.trim())) {
                    ok = false;
                } else {
                    this.keyStore.putKey(pkName, pkValue.trim());
                }
                if (ok) {
                    executer.insert(t.getSqlName(), fnames, values);
                }
            }
            monitor.setProgress(rc);
            ++rc;
        }
    }

    private boolean getFieldSqlNamed(String depends) {
        return false;
    }

    private boolean pkExists(String fieldName, String fieldValue) {
        if (fieldName.equals("")) {
            return false;
        }
        if (this.keyStore.keyExists(fieldName, fieldValue)) {
            System.out.print("Duplicate key: " + fieldValue);
        }
        return this.keyStore.keyExists(fieldName, fieldValue);
    }

    private boolean pkEmpty(Field f) {
        return f.getType() != null && f.getType().startsWith("pk") && f.getDbfField().get().trim().equals("");
    }
}

