/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.migration.progress;

import rs.pezar.creator.tools.migration.progress.MigrationMonitor;

public class TextualMonitor
implements MigrationMonitor {
    @Override
    public void migratingFromTable(String tableName) {
        System.out.println("----------------------------------------------------------------");
        System.out.print("Migrating dBase table " + tableName);
    }

    @Override
    public void migratingToTable(String tableName) {
        System.out.println(" to SQL table " + tableName);
    }

    @Override
    public void setProgressLength(int length) {
        System.out.println("Number of records to migrate: " + length);
        System.out.print("Progress: ");
    }

    @Override
    public void setProgress(int progress) {
        if (progress % 300 == 0) {
            System.out.println();
        }
        System.out.print(".");
    }

    @Override
    public void tableMigrated(String dbfTable, String sqlTable) {
        System.out.println();
        System.out.println(String.format("MigrationExecuter %s ---> %s completed successfully", dbfTable, sqlTable));
        System.out.println("----------------------------------------------------------------");
    }

    @Override
    public void exceptionThrown(Exception e, String lastInsert) {
        System.out.println("Exception on insert: " + lastInsert);
        e.printStackTrace();
    }

    @Override
    public void dependsOnInsert(String sqlTable, String fileToInsert) {
        System.out.println("Table " + sqlTable + " depends on " + fileToInsert);
        System.out.println("Inserting data from " + fileToInsert + " to database.");
    }

    @Override
    public void needsCleanUp(String dbfTableName) {
        System.out.println("Table " + dbfTableName + " needs cleaning up.");
        System.out.println("Performing clean up operation on table " + dbfTableName);
    }

    @Override
    public void processCompleted() {
        System.out.println("Migration process completed successfully");
    }
}

