/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.creator.tools.xml;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import rs.pezar.creator.tools.xml.XmlElement;
import rs.pezar.creator.tools.xml.XmlHeaderElement;
import rs.pezar.creator.tools.xml.XmlParser;

public class XmlLoader {
    private File[] files;
    private static final String insertStatement = "INSERT INTO %s (%s) VALUES (%s)";
    private String tableName;
    private String tableFields = new String();
    private Vector<XmlHeaderElement> headerElement = new Vector();
    private Vector<XmlElement> records = new Vector();
    private String tableValues;
    private Document doc;
    private int noOfRecords;

    public XmlLoader(String dirName) {
        this.init(dirName);
    }

    public File[] getFiles() {
        return this.files;
    }

    public void init(String dirName) {
        File dir = new File(dirName);
        this.files = dir.listFiles();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String temp = name.substring(name.length() - 4);
                String temp1 = ".xml";
                return temp.equalsIgnoreCase(temp1);
            }
        };
        this.files = dir.listFiles(filter);
    }

    public void loadXml(String xml) throws Exception {
        try {
            this.doc = XmlParser.loadXML(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.getXmlProperties();
    }

    private void getXmlProperties() throws Exception {
        NodeList xmlitem = this.doc.getElementsByTagName("Tablename");
        if (xmlitem.getLength() == 0) {
            throw new Exception("Improper xml format, check the documentation for help.");
        }
        this.setTableName(xmlitem.item(0).getAttributes().getNamedItem("name").getTextContent());
        NodeList nl = this.doc.getElementsByTagName("Field");
        if (nl.getLength() == 0) {
            throw new Exception("Improper xml format, check the documentation for help.");
        }
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(i);
                this.headerElement.add(new XmlHeaderElement(el));
                this.addField(this.headerElement.elementAt(i).getFieldName());
                ++i;
            }
        }
    }

    public void getXmlValues() throws Exception {
        Node fstNode = null;
        if (this.doc == null) {
            throw new Exception("Xml not loaded");
        }
        NodeList xmlitem = this.doc.getElementsByTagName("Record");
        this.noOfRecords = xmlitem.getLength();
        int i = 0;
        while (i < this.noOfRecords) {
            fstNode = xmlitem.item(i);
            this.records.add(new XmlElement((Element)fstNode, this.headerElement));
            ++i;
        }
    }

    public String getSqlInsertFormatedString(int i) {
        this.tableValues = this.records.get(i).getFormatedOutput();
        String fullStatement = String.format(insertStatement, this.tableName, this.tableFields, this.tableValues);
        return fullStatement;
    }

    public int getNoOfRecords() {
        return this.noOfRecords;
    }

    private void setTableName(String tname) {
        this.tableName = tname;
    }

    private void addField(String field) {
        this.tableFields = this.tableFields.equals("") ? field : String.format("%s,%s", this.tableFields, field);
    }

    private void addValue(String value) {
        this.tableValues = this.tableValues.equals("") ? value : String.format("%s,%s", this.tableValues, value);
    }
}

