/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.DataFileAppender;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.util.ByteSequence;

final class DataFileAccessor {
    private final DataFile dataFile;
    private final Map<DataFileAppender.WriteKey, DataFileAppender.WriteCommand> inflightWrites;
    private final RandomAccessFile file;
    private boolean disposed;

    public DataFileAccessor(Journal dataManager, DataFile dataFile) throws IOException {
        this.dataFile = dataFile;
        this.inflightWrites = dataManager.getInflightWrites();
        this.file = dataFile.openRandomAccessFile();
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.dataFile.closeRandomAccessFile(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ByteSequence readRecord(Location location) throws IOException {
        if (!location.isValid()) {
            throw new IOException("Invalid location: " + location);
        }
        DataFileAppender.WriteCommand asyncWrite = this.inflightWrites.get(new DataFileAppender.WriteKey(location));
        if (asyncWrite != null) {
            return asyncWrite.data;
        }
        try {
            if (location.getSize() == -1) {
                this.file.seek(location.getOffset());
                location.setSize(this.file.readInt());
                location.setType(this.file.readByte());
            } else {
                this.file.seek(location.getOffset() + 5);
            }
            byte[] data = new byte[location.getSize() - 5];
            this.file.readFully(data);
            return new ByteSequence(data, 0, data.length);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid location: " + location + ", : " + e);
        }
    }

    public void readFully(long offset, byte[] data) throws IOException {
        this.file.seek(offset);
        this.file.readFully(data);
    }

    public int read(long offset, byte[] data) throws IOException {
        this.file.seek(offset);
        return this.file.read(data);
    }

    public void readLocationDetails(Location location) throws IOException {
        DataFileAppender.WriteCommand asyncWrite = this.inflightWrites.get(new DataFileAppender.WriteKey(location));
        if (asyncWrite != null) {
            location.setSize(asyncWrite.location.getSize());
            location.setType(asyncWrite.location.getType());
        } else {
            this.file.seek(location.getOffset());
            location.setSize(this.file.readInt());
            location.setType(this.file.readByte());
        }
    }

    public void updateRecord(Location location, ByteSequence data, boolean sync) throws IOException {
        this.file.seek(location.getOffset() + 5);
        int size = Math.min(data.getLength(), location.getSize());
        this.file.write(data.getData(), data.getOffset(), size);
        if (sync) {
            this.file.getFD().sync();
        }
    }
}

