/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection.factory;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.factory.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectFactory
implements ObjectFactory {
    @Override
    public Object create(Class type) {
        return this.create(type, null, null);
    }

    @Override
    public Object create(Class type, List<Class> constructorArgTypes, List<Object> constructorArgs) {
        Class classToCreate = this.resolveCollectionInterface(type);
        return this.instantiateClass(classToCreate, constructorArgTypes, constructorArgs);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    private Object instantiateClass(Class type, List<Class> constructorArgTypes, List<Object> constructorArgs) {
        try {
            if (constructorArgTypes == null || constructorArgs == null) {
                Constructor constructor = type.getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            Constructor constructor = type.getDeclaredConstructor(constructorArgTypes.toArray(new Class[constructorArgTypes.size()]));
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(constructorArgs.toArray(new Object[constructorArgs.size()]));
        }
        catch (Exception e) {
            StringBuilder argTypes = new StringBuilder();
            if (constructorArgTypes != null) {
                for (Class argType : constructorArgTypes) {
                    argTypes.append(argType.getSimpleName());
                    argTypes.append(",");
                }
            }
            StringBuilder argValues = new StringBuilder();
            if (constructorArgs != null) {
                for (Object argValue : constructorArgs) {
                    argValues.append(String.valueOf(argValue));
                    argValues.append(",");
                }
            }
            throw new ReflectionException("Error instantiating " + type + " with invalid types (" + argTypes + ") or values (" + argValues + "). Cause: " + e, e);
        }
    }

    private Class resolveCollectionInterface(Class type) {
        Class classToCreate = type == List.class || type == Collection.class ? ArrayList.class : (type == Map.class ? HashMap.class : (type == Set.class ? HashSet.class : type));
        return classToCreate;
    }
}

