/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancerConsumer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.spi.BrowsableEndpoint;

public class BrowseEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint,
Service {
    private List<Exchange> exchanges;
    private final LoadBalancer loadBalancer = new TopicLoadBalancer();

    public BrowseEndpoint() {
    }

    public BrowseEndpoint(String uri, CamelContext camelContext) {
        super(uri, camelContext);
    }

    public BrowseEndpoint(String uri, Component component) {
        super(uri, component);
    }

    public BrowseEndpoint(String endpointUri) {
        super(endpointUri);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public List<Exchange> getExchanges() {
        if (this.exchanges == null) {
            this.exchanges = this.createExchangeList();
        }
        return this.exchanges;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultProducer(this){

            @Override
            public void process(Exchange exchange) throws Exception {
                BrowseEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new LoadBalancerConsumer(this, processor, this.loadBalancer);
    }

    protected List<Exchange> createExchangeList() {
        return new CopyOnWriteArrayList<Exchange>();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.getExchanges().add(exchange);
        this.loadBalancer.process(exchange);
    }

    @Override
    public void start() throws Exception {
        this.exchanges = this.createExchangeList();
    }

    @Override
    public void stop() throws Exception {
        if (this.exchanges != null) {
            this.exchanges.clear();
            this.exchanges = null;
        }
    }
}

