/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CamelContext camelContext;
    protected ProducerCache producerCache;
    protected Endpoint destination;
    protected ExchangePattern pattern;

    public SendProcessor(Endpoint destination) {
        ObjectHelper.notNull(destination, "destination");
        this.destination = destination;
        this.camelContext = destination.getCamelContext();
        ObjectHelper.notNull(this.camelContext, "camelContext");
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        this(destination);
        this.pattern = pattern;
    }

    public String toString() {
        return "sendTo(" + this.destination + (this.pattern != null ? " " + (Object)((Object)this.pattern) : "") + ")";
    }

    public void setDestination(Endpoint destination) {
        this.destination = destination;
    }

    @Override
    public String getTraceLabel() {
        return this.destination.getEndpointUri();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (!this.isStarted()) {
            throw new IllegalStateException("SendProcessor has not been started: " + this);
        }
        this.producerCache.doInProducer(this.destination, exchange, this.pattern, new ProducerCallback<Exchange>(){

            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) throws Exception {
                exchange = SendProcessor.this.configureExchange(exchange, pattern);
                if (SendProcessor.this.log.isDebugEnabled()) {
                    SendProcessor.this.log.debug(">>>> " + SendProcessor.this.destination + " " + exchange);
                }
                producer.process(exchange);
                return exchange;
            }
        });
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            throw new IllegalStateException("SendProcessor has not been started: " + this);
        }
        return this.producerCache.doInAsyncProducer(this.destination, exchange, this.pattern, callback, new AsyncProducerCallback(){

            @Override
            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, Exchange exchange, ExchangePattern pattern, AsyncCallback callback) {
                exchange = SendProcessor.this.configureExchange(exchange, pattern);
                if (SendProcessor.this.log.isDebugEnabled()) {
                    SendProcessor.this.log.debug(">>>> " + SendProcessor.this.destination + " " + exchange);
                }
                return AsyncProcessorHelper.process(asyncProducer, exchange, callback);
            }
        });
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        return exchange;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(this, this.camelContext);
            this.camelContext.addService(this.producerCache);
        }
        ServiceHelper.startService(this.producerCache);
        Endpoint lookup = this.camelContext.hasEndpoint(this.destination.getEndpointKey());
        if (lookup instanceof InterceptSendToEndpoint) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Intercepted sending to " + this.destination.getEndpointUri() + " -> " + lookup.getEndpointUri());
            }
            this.destination = lookup;
        }
        ServiceHelper.startService(this.destination);
        this.producerCache.startProducer(this.destination);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache);
    }
}

