/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.xbean.spring.context.ResourceXmlApplicationContext;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;

public class XBeanBrokerFactory
implements BrokerFactoryHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(XBeanBrokerFactory.class);
    private boolean validate = true;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public BrokerService createBroker(URI config) throws Exception {
        String uri = config.getSchemeSpecificPart();
        if (uri.lastIndexOf(63) != -1) {
            IntrospectionSupport.setProperties((Object)this, (Map)URISupport.parseQuery((String)uri));
            uri = uri.substring(0, uri.lastIndexOf(63));
        }
        ApplicationContext context = this.createApplicationContext(uri);
        BrokerService broker = null;
        try {
            broker = (BrokerService)context.getBean("broker");
        }
        catch (BeansException e) {
            // empty catch block
        }
        if (broker == null) {
            String name;
            String[] names = context.getBeanNamesForType(BrokerService.class);
            for (int i = 0; i < names.length && (broker = (BrokerService)context.getBean(name = names[i])) == null; ++i) {
            }
        }
        if (broker == null) {
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + config);
        }
        if (broker instanceof ApplicationContextAware) {
            ((ApplicationContextAware)broker).setApplicationContext(context);
        }
        return broker;
    }

    protected ApplicationContext createApplicationContext(String uri) throws MalformedURLException {
        LOG.debug("Now attempting to figure out the type of resource: " + uri);
        File file = new File(uri);
        Object resource = file.exists() ? new FileSystemResource(uri) : (ResourceUtils.isUrl((String)uri) ? new UrlResource(uri) : new ClassPathResource(uri));
        return new ResourceXmlApplicationContext((Resource)resource){

            protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
                reader.setValidating(XBeanBrokerFactory.this.isValidate());
            }
        };
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }
}

