/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiDataFormatResolver
implements DataFormatResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(OsgiDataFormatResolver.class);
    private final BundleContext bundleContext;

    public OsgiDataFormatResolver(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public DataFormat resolveDataFormat(String name, CamelContext context) {
        Object bean;
        block4: {
            bean = null;
            try {
                bean = context.getRegistry().lookup(name);
                if (bean != null && LOG.isDebugEnabled()) {
                    LOG.debug("Found language: " + name + " in registry: " + bean);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Ignored error looking up bean: " + name + ". Error: " + e);
            }
        }
        if (bean instanceof DataFormat) {
            return (DataFormat)bean;
        }
        return this.getDataFormat(name, context);
    }

    public DataFormatDefinition resolveDataFormatDefinition(String name, CamelContext context) {
        DataFormatDefinition type = OsgiDataFormatResolver.lookup(context, name, DataFormatDefinition.class);
        if (type == null && context.getDataFormats() != null) {
            type = (DataFormatDefinition)context.getDataFormats().get(name);
        }
        return type;
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return (T)context.getRegistry().lookup(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected DataFormat getDataFormat(String name, CamelContext context) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finding DataFormat: " + name);
        }
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(DataFormatResolver.class.getName(), "(dataformat=" + name + ")");
            if (refs != null && refs.length > 0) {
                DataFormatResolver resolver = (DataFormatResolver)this.bundleContext.getService(refs[0]);
                return resolver.resolveDataFormat(name, context);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

