/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.xcelerate.app.commands.RemoveView;
import rs.tetrabyte.xcelerate.app.commands.UICommand;
import rs.tetrabyte.xcelerate.app.context.ScreenService;
import rs.tetrabyte.xcelerate.app.control.PFXDialog;
import rs.tetrabyte.xcelerate.app.factory.XButtonFactory;
import rs.tetrabyte.xcelerate.app.factory.XButtonType;
import rs.tetrabyte.xcelerate.core.fxml.LocaleContext;

public class ShowDialog<T>
extends UICommand {
    private static final String NAME = "show-dialog";
    @Autowired
    private XButtonFactory buttonFactory;
    @Autowired
    private LocaleContext localeContext;
    @Autowired
    private ScreenService screen;
    private String title;
    private Node graphic;
    private Node content;
    private int width;
    private int height;
    private List<Button> buttons = new ArrayList<Button>();
    private PFXDialog<T> dialog;
    Class<T> valueClass;
    private Consumer<PFXDialog<T>> onValueSet;
    private Consumer<PFXDialog<T>> onOpened;
    private Object[] titleArgs;

    @Override
    void validate() {
    }

    @Override
    String getName() {
        return NAME;
    }

    ShowDialog<T> withValueClass(Class<T> valueClass) {
        this.valueClass = valueClass;
        return this;
    }

    public ShowDialog<T> withTitle(String title, Object ... args) {
        this.title = title;
        this.titleArgs = args;
        return this;
    }

    public ShowDialog<T> withGraphic(Node graphic) {
        this.graphic = graphic;
        return this;
    }

    public ShowDialog<T> withContent(Node content) {
        this.content = content;
        return this;
    }

    public ShowDialog<T> withButton(Button btn, Consumer<PFXDialog<T>> value) {
        EventHandler handler = e -> value.accept(this.dialog);
        btn.setOnAction(handler);
        this.buttons.add(btn);
        return this;
    }

    public ShowDialog<T> withWidth(int width) {
        this.width = width;
        return this;
    }

    public ShowDialog<T> withHeight(int height) {
        this.height = height;
        return this;
    }

    public ShowDialog<T> onValueSet(Consumer<PFXDialog<T>> onValueSet) {
        this.onValueSet = onValueSet;
        return this;
    }

    public ShowDialog<T> onOpened(Consumer<PFXDialog<T>> onOpened) {
        this.onOpened = onOpened;
        return this;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public Node getContent() {
        return this.content;
    }

    public Node getGraphic() {
        return this.graphic;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.width;
    }

    public PFXDialog<T> getDialog() {
        return this.dialog;
    }

    public Consumer<PFXDialog<T>> getOnValueSet() {
        return this.onValueSet;
    }

    public Consumer<PFXDialog<T>> getOnOpened() {
        return this.onOpened;
    }

    @Override
    public void execute() {
        if (this.title != null && this.title.startsWith("%")) {
            this.title = this.localeContext.getMessage(this.title.substring(1), this.titleArgs);
        }
        this.dialog = new PFXDialog(this, this.getCommandFactory().createCommand(RemoveView.class));
        Button cancelBtn = this.buttonFactory.createButton(XButtonType.Cancel);
        cancelBtn.setOnAction(e -> this.dialog.close());
        this.dialog.getButtons().add((Object)cancelBtn);
        super.execute(false);
        this.screen.showDialog(this);
    }
}

