/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.context.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;
import rs.tetrabyte.xcelerate.app.control.Accelerable;
import rs.tetrabyte.xcelerate.app.control.LockablePane;
import rs.tetrabyte.xcelerate.app.control.Screen;

public class AcceleratorServiceImpl
implements AcceleratorService {
    private static Logger LOGGER = LoggerFactory.getLogger(AcceleratorServiceImpl.class);
    private static final double JAVA_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
    private Scene scene;
    private Screen screen;
    private Map<KeyCombination, Runnable> active = new ConcurrentHashMap<KeyCombination, Runnable>();

    public void setScene(Scene scene) {
        this.scene = scene;
        this.screen = (Screen)scene.getRoot();
        this.applyWorkaround();
    }

    @Override
    public Optional<Runnable> getAccelerator(KeyCombination comb) {
        if (this.active.containsKey(comb)) {
            return Optional.of(this.active.get(comb));
        }
        return Optional.empty();
    }

    private void applyWorkaround() {
        EventHandler<KeyEvent> eventHandler1 = this.createEventHandler1();
        this.scene.focusOwnerProperty().addListener((o, ov, nv) -> {
            if (nv instanceof TableView || nv instanceof TreeTableView || nv instanceof ListView) {
                nv.addEventFilter(KeyEvent.KEY_PRESSED, eventHandler1);
            }
            if (ov instanceof TableView || ov instanceof TreeTableView || ov instanceof ListView) {
                ov.removeEventFilter(KeyEvent.KEY_PRESSED, eventHandler1);
            }
        });
        if (JAVA_VERSION < 9.0) {
            EventHandler<KeyEvent> eventHandler2 = this.createEventHandler2();
            this.scene.focusOwnerProperty().addListener((o, ov, nv) -> {
                if (nv instanceof TextField) {
                    nv.addEventFilter(KeyEvent.KEY_PRESSED, eventHandler2);
                }
                if (ov instanceof TextField) {
                    ov.removeEventFilter(KeyEvent.KEY_PRESSED, eventHandler2);
                }
            });
        }
    }

    private EventHandler<KeyEvent> createEventHandler1() {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                Runnable r;
                if ((e.getCode() == KeyCode.ESCAPE || e.getCode() == KeyCode.F2) && (r = AcceleratorServiceImpl.this.active.get(KeyCombination.keyCombination((String)e.getCode().getName()))) != null) {
                    Platform.runLater((Runnable)r);
                }
            }
        };
    }

    private EventHandler<KeyEvent> createEventHandler2() {
        return new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().isModifierKey() || event.getCode() == KeyCode.DELETE || event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.BACK_SPACE || event.getCode() == KeyCode.ESCAPE || event.isAltDown() || event.isShiftDown() || event.isControlDown()) {
                    return;
                }
                AcceleratorServiceImpl.this.active.entrySet().stream().forEach(ent -> {
                    if (((KeyCombination)ent.getKey()).match(event)) {
                        Platform.runLater((Runnable)((Runnable)ent.getValue()));
                    }
                });
            }
        };
    }

    @Override
    public void refresh() {
        this.screen.getFrontLayer().ifPresent(frontLayer -> {
            this.clear();
            this.activate(AcceleratorServiceImpl.findAccelerators(frontLayer));
        });
    }

    @Override
    public void set(Node node) {
        this.clear();
        this.activate(AcceleratorServiceImpl.findAccelerators(node));
    }

    private void clear() {
        this.active.clear();
        this.scene.getAccelerators().clear();
        LOGGER.debug("All accelerators removed");
    }

    private void activate(Map<KeyCombination, Runnable> accelerators) {
        if (accelerators.isEmpty()) {
            return;
        }
        this.active.putAll(accelerators);
        this.scene.getAccelerators().putAll(this.active);
        String activeAccelerators = String.join((CharSequence)", ", accelerators.entrySet().stream().map(e -> ((KeyCombination)e.getKey()).toString()).collect(Collectors.toList()));
        LOGGER.debug("Active accelerators: " + activeAccelerators);
    }

    private static List<Accelerable> findAccelerables(Object node) {
        ArrayList<Accelerable> accelerables = new ArrayList<Accelerable>();
        if (node instanceof Accelerable) {
            accelerables.add((Accelerable)node);
            if (node instanceof Parent) {
                ((Parent)node).getChildrenUnmodifiable().forEach(childNode -> accelerables.addAll(AcceleratorServiceImpl.findAccelerables(childNode)));
            }
        } else if (node instanceof Parent) {
            accelerables.addAll(AcceleratorServiceImpl.findAccelerables((Parent)node));
        }
        return accelerables;
    }

    private static List<Accelerable> findAccelerables(Parent node) {
        ArrayList<Accelerable> accelerables = new ArrayList<Accelerable>();
        if (node instanceof LockablePane) {
            LockablePane lockable = (LockablePane)node;
            lockable.getFrontLayer().ifPresent(frontLayer -> accelerables.addAll(AcceleratorServiceImpl.findAccelerables(frontLayer)));
        } else if (node instanceof StackPane) {
            StackPane stackPane = (StackPane)node;
            if (stackPane.getChildren().size() > 0) {
                accelerables.addAll(AcceleratorServiceImpl.findAccelerables(stackPane.getChildren().get(stackPane.getChildren().size() - 1)));
            }
        } else if (node instanceof ToolBar) {
            ToolBar toolbar = (ToolBar)node;
            toolbar.getItems().forEach(items -> accelerables.addAll(AcceleratorServiceImpl.findAccelerables(items)));
        } else if (node instanceof ButtonBar) {
            ButtonBar buttonBar = (ButtonBar)node;
            buttonBar.getButtons().forEach(button -> accelerables.addAll(AcceleratorServiceImpl.findAccelerables(button)));
        } else if (node instanceof TitledPane) {
            TitledPane titledPane = (TitledPane)node;
            accelerables.addAll(AcceleratorServiceImpl.findAccelerables(titledPane.getContent()));
        } else if (node instanceof TabPane) {
            TabPane tabPane = (TabPane)node;
            tabPane.getTabs().forEach(tab -> accelerables.addAll(AcceleratorServiceImpl.findAccelerables(tab)));
            if (tabPane.getSelectionModel().getSelectedItem() != null) {
                accelerables.addAll(AcceleratorServiceImpl.findAccelerables(((Tab)tabPane.getSelectionModel().getSelectedItem()).getContent()));
            }
        } else {
            node.getChildrenUnmodifiable().forEach(child -> accelerables.addAll(AcceleratorServiceImpl.findAccelerables(child)));
        }
        return accelerables;
    }

    private static Map<KeyCombination, Runnable> findAccelerators(Node node) {
        List<Accelerable> accelerables = AcceleratorServiceImpl.findAccelerables(node);
        HashMap<KeyCombination, Runnable> accelerators = new HashMap<KeyCombination, Runnable>();
        accelerables.forEach(accelerable -> {
            if (accelerable.getAcceleratorString() != null && accelerable.getAcceleratorString().length() > 0) {
                accelerators.put(KeyCombination.keyCombination((String)accelerable.getAcceleratorString()), () -> {
                    LOGGER.debug("Accelerator triggered: " + accelerable.getAcceleratorString());
                    if (accelerable instanceof Button) {
                        Button b = (Button)accelerable;
                        if (b.isFocusTraversable()) {
                            b.requestFocus();
                        }
                        b.fire();
                    } else if (accelerable instanceof MenuItem) {
                        ((MenuItem)accelerable).fire();
                    } else if (accelerable instanceof Label) {
                        if (((Label)accelerable).getLabelFor() != null) {
                            ((Label)accelerable).getLabelFor().requestFocus();
                        }
                    } else if (accelerable instanceof Tab) {
                        ((Tab)accelerable).getTabPane().getSelectionModel().select((Object)((Tab)accelerable));
                    }
                });
            }
        });
        return accelerators;
    }
}

