/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.context.impl;

import javafx.scene.control.ButtonType;
import rs.tetrabyte.xcelerate.app.commands.ClearScreen;
import rs.tetrabyte.xcelerate.app.commands.DisplayContent;
import rs.tetrabyte.xcelerate.app.commands.LockUI;
import rs.tetrabyte.xcelerate.app.commands.PopContent;
import rs.tetrabyte.xcelerate.app.commands.RemoveView;
import rs.tetrabyte.xcelerate.app.commands.ShowAlert;
import rs.tetrabyte.xcelerate.app.commands.ShowDialog;
import rs.tetrabyte.xcelerate.app.commands.UnlockUI;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;
import rs.tetrabyte.xcelerate.app.context.FocusService;
import rs.tetrabyte.xcelerate.app.context.ScreenService;
import rs.tetrabyte.xcelerate.app.control.Screen;
import rs.tetrabyte.xcelerate.app.factory.SubScreenFactory;
import rs.tetrabyte.xcelerate.core.fxml.LocaleContext;

public class ScreenServiceImpl
implements ScreenService {
    private LocaleContext localeContext;
    private Screen screen;

    public ScreenServiceImpl(LocaleContext localeContext, SubScreenFactory subScreenFactory, AcceleratorService acceleratorService, FocusService focusService) {
        this.localeContext = localeContext;
        this.screen = new Screen(subScreenFactory, acceleratorService, focusService);
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public void removeView(RemoveView command) {
        this.screen.removeView(command.getView());
    }

    @Override
    public void showDialog(ShowDialog<?> command) {
        this.screen.showDialog(command.getDialog().getDialogPane());
        if (command.getOnOpened() != null) {
            command.getOnOpened().accept(command.getDialog());
        }
    }

    @Override
    public void displayContent(DisplayContent command) {
        if (command.getTarget() == DisplayContent.TargetContainer.Screen) {
            this.screen.displayContent(command.getContent(), command.isSingletonContent(), command.isClosable(), command.getActions(), command.getCallback());
        }
    }

    void popContent(PopContent command) {
        this.screen.popNode();
    }

    @Override
    public void lock(LockUI lockui) {
        if (lockui.getMessage() != null) {
            String message = lockui.getMessage();
            if (message.startsWith("%")) {
                message = this.localeContext.getMessage(message.substring(1, message.length()), lockui.getMessageArgs());
            }
            this.screen.setMessage(message + ". " + this.localeContext.getMessage("msg.please-wait", new Object[0]));
        }
        this.screen.lock();
    }

    @Override
    public void unlock(UnlockUI unlockui) {
        this.screen.setMessage(this.localeContext.getMessage("msg.please-wait", new Object[0]));
        this.screen.unlock();
    }

    @Override
    public void clearScreen(ClearScreen command) {
        this.screen.clear();
    }

    @Override
    public void showAlert(ShowAlert command) {
        command.getAlert(this.screen, this.localeContext).showAndWait().ifPresent(buttonType -> {
            if (command.getOnConfirmed() != null && buttonType == ButtonType.OK) {
                command.getOnConfirmed().handle(null);
            }
        });
    }
}

