/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.context.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import rs.tetrabyte.xcelerate.app.context.UiSettingService;

public class UiSettingServiceImpl
implements UiSettingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UiSettingServiceImpl.class);
    private final UiSettingService.UiSettingProvider provider;
    private final List<UiSettingService.UiSettingFactory<?>> factories;

    public UiSettingServiceImpl(UiSettingService.UiSettingProvider provider) {
        this.provider = provider;
        this.factories = new ArrayList();
        this.registerSettingFactory(new ColumnSettingsFactory());
    }

    @Override
    public void registerSettingFactory(UiSettingService.UiSettingFactory<?> factory) {
        if (!this.factories.stream().filter(f -> f.getClass().equals(factory.getClass())).findAny().isPresent()) {
            this.factories.add(factory);
        }
    }

    @Override
    public <T> void save(UiSettingService.UiSetting<T> setting) {
        if (this.provider == null) {
            LOGGER.warn("Failed to save settings. No provider found.");
        } else if (setting == null) {
            LOGGER.warn("Failed to save settings. Null value provided.");
        } else if (setting.getSettingId() == null) {
            LOGGER.warn("Can't save setting that doesn't have an ID");
        } else {
            this.provider.save(setting);
        }
    }

    @Override
    public void save(Node node) {
        this.factories.forEach(f -> {
            if (f.accept(node)) {
                if (node.getId() == null) {
                    LOGGER.warn("Node does not have an ID. Skipping state save " + node);
                    return;
                }
                UiSettingService.UiSetting setting = f.toSetting(node);
                this.save(setting);
            } else if (node instanceof Parent) {
                Parent parent = (Parent)node;
                parent.getChildrenUnmodifiable().forEach(child -> this.save((Node)child));
            }
        });
    }

    @Override
    public <T> void restore(String settingId, Class<T> type, Consumer<UiSettingService.UiSetting<T>> setting) {
        if (this.provider == null) {
            LOGGER.warn("Failed to restore settings. No provider found.");
        }
        this.provider.restore(settingId, type, setting);
    }

    @Override
    public void restore(Node node) {
        this.factories.forEach(f -> {
            if (f.accept(node)) {
                if (node.getId() == null) {
                    LOGGER.warn("Node does not have an ID. Skipping state restore " + node);
                    return;
                }
                this.restore(node.getId(), f.getValueType(), setting -> {
                    f.restore(node, setting);
                    LOGGER.debug("Node state restored: " + node.getId());
                });
            } else if (node instanceof Parent) {
                Parent parent = (Parent)node;
                parent.getChildrenUnmodifiable().forEach(child -> this.restore((Node)child));
                parent.getChildrenUnmodifiable().addListener((ListChangeListener)new ListChangeListener<Node>(){

                    public void onChanged(ListChangeListener.Change<? extends Node> c) {
                        while (c.next()) {
                            if (!c.wasAdded()) continue;
                            c.getAddedSubList().forEach(e -> UiSettingServiceImpl.this.restore((Node)e));
                        }
                    }
                });
            }
        });
    }

    private static class ColumnSettingsFactory
    implements UiSettingService.UiSettingFactory<TableMetaData> {
        private ColumnSettingsFactory() {
        }

        @Override
        public boolean accept(Node node) {
            return node.getClass() == TableView.class || node.getClass() == TreeTableView.class;
        }

        @Override
        public Class<TableMetaData> getValueType() {
            return TableMetaData.class;
        }

        @Override
        public UiSettingService.UiSetting<TableMetaData> toSetting(Node node) {
            TableMetaData metadata = new TableMetaData();
            if (node instanceof TableView) {
                TableView t = (TableView)node;
                t.getColumns().forEach(c -> metadata.getColumns().add(new ColumnMetadata(c.getId(), c.getWidth(), c.isVisible())));
            } else if (node instanceof TreeTableView) {
                TreeTableView t = (TreeTableView)node;
                t.getColumns().forEach(c -> metadata.getColumns().add(new ColumnMetadata(c.getId(), c.getWidth(), c.isVisible())));
            }
            return new UiSettingService.UiSetting<TableMetaData>(node.getId(), metadata);
        }

        @Override
        public void restore(Node node, UiSettingService.UiSetting<TableMetaData> setting) {
            if (setting == null || setting.getValue() == null) {
                return;
            }
            if (node instanceof TableView) {
                TableView t = (TableView)node;
                t.getColumns().forEach(c -> {
                    ColumnMetadata metadata = ((TableMetaData)setting.getValue()).findColumn(c.getId());
                    if (metadata != null) {
                        c.setPrefWidth(metadata.getWidth());
                        c.setVisible(metadata.isVisible());
                    }
                });
            } else if (node instanceof TreeTableView) {
                TreeTableView t = (TreeTableView)node;
                t.getColumns().forEach(c -> {
                    ColumnMetadata metadata = ((TableMetaData)setting.getValue()).findColumn(c.getId());
                    if (metadata != null) {
                        c.setPrefWidth(metadata.getWidth());
                        c.setVisible(metadata.isVisible());
                    }
                });
            }
        }
    }

    public static class ColumnMetadata {
        private String id;
        private double width;
        private boolean visible;

        public ColumnMetadata(String id, double width, boolean visible) {
            this.id = id;
            this.width = width;
            this.visible = visible;
        }

        public ColumnMetadata() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public double getWidth() {
            return this.width;
        }

        public void setWidth(double width) {
            this.width = width;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }
    }

    public static class TableMetaData {
        private List<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();

        public List<ColumnMetadata> getColumns() {
            return this.columns;
        }

        public void setColumns(List<ColumnMetadata> columns) {
            this.columns = columns;
        }

        public ColumnMetadata findColumn(String id) {
            if (id == null) {
                return null;
            }
            if (this.columns == null) {
                return null;
            }
            ColumnMetadata metadata = null;
            Iterator<ColumnMetadata> iterator = this.columns.iterator();
            while (iterator.hasNext() && metadata == null) {
                ColumnMetadata temp = iterator.next();
                if (!id.equals(temp.getId())) continue;
                metadata = temp;
            }
            return metadata;
        }
    }

    public class UiSettingTypeReference<E>
    extends ParameterizedTypeReference<UiSettingService.UiSetting<E>> {
        private Class<E> valueType;

        public UiSettingTypeReference(Class<E> type) {
            this.valueType = type;
        }

        public Type getType() {
            ParameterizedType resourceType = new ParameterizedType(){

                @Override
                public Type getRawType() {
                    return UiSettingService.UiSetting.class;
                }

                @Override
                public Type getOwnerType() {
                    return UiSettingService.UiSetting.class;
                }

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{UiSettingTypeReference.this.valueType};
                }
            };
            return resourceType;
        }
    }
}

