/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;
import rs.tetrabyte.xcelerate.app.context.FocusService;
import rs.tetrabyte.xcelerate.app.control.MaskerPane;
import rs.tetrabyte.xcelerate.core.task.UIAccessor;

public class LockablePane
extends StackPane
implements UIAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockablePane.class);
    private StackPane content;
    private MaskerPane maskerPane;
    private BooleanProperty locked = new SimpleBooleanProperty(false);
    private AcceleratorService acceleratorService;
    private FocusService focusService;

    public LockablePane(Node node, AcceleratorService acceleratorService, FocusService focusService) {
        this.content = new StackPane(new Node[]{node});
        this.getChildren().add((Object)this.content);
        this.acceleratorService = acceleratorService;
        this.focusService = focusService;
        this.handleLocking();
    }

    public LockablePane(AcceleratorService acceleratorService, FocusService focusService) {
        this.content = new StackPane();
        this.getChildren().add((Object)this.content);
        this.acceleratorService = acceleratorService;
        this.focusService = focusService;
        this.handleLocking();
    }

    private MaskerPane maskerPane() {
        if (this.maskerPane == null) {
            this.maskerPane = new MaskerPane();
        }
        return this.maskerPane;
    }

    public Optional<Node> getFrontLayer() {
        if (this.content.getChildren().size() == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable((Node)this.content.getChildren().get(this.content.getChildren().size() - 1));
    }

    public ObservableList<Node> getViews() {
        return this.content.getChildren();
    }

    private void handleLocking() {
        EventHandler blockKeyInput = e -> {
            e.consume();
            LOGGER.debug("Blocked key input: " + e);
        };
        this.locked.addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                if (this.getFrontLayer().isPresent()) {
                    LOGGER.debug("lock UI - " + this.getFrontLayer().get());
                }
                this.getChildren().add((Object)this.maskerPane());
                this.addEventFilter(KeyEvent.ANY, blockKeyInput);
            } else if (!nv.booleanValue()) {
                if (this.getFrontLayer().isPresent()) {
                    LOGGER.debug("unlock UI - " + this.getFrontLayer().get());
                }
                this.getChildren().remove((Object)this.maskerPane());
                this.removeEventFilter(KeyEvent.ANY, blockKeyInput);
            }
        });
    }

    public void lock(String message) {
        this.maskerPane().setText(message);
        this.setLocked(true);
    }

    public void lock() {
        this.setLocked(true);
    }

    public void unlock() {
        this.setLocked(false);
    }

    public void setMessage(String message) {
        this.maskerPane().setText(message);
    }

    public final BooleanProperty lockedProperty() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.lockedProperty().set(locked);
    }

    public void addNodeOnTop(Node node, boolean restoreFocus) {
        this.saveFrontLayerFocus();
        if (!this.content.getChildren().contains((Object)node)) {
            this.disableAllLayers();
            this.content.getChildren().add((Object)node);
        }
        this.acceleratorService.set(node);
        this.handleFrontLayerFocus(restoreFocus);
    }

    public void addNodeOnTop(Node node) {
        this.addNodeOnTop(node, true);
    }

    public void removeNode(Node node) {
        this.saveFrontLayerFocus();
        this.content.getChildren().remove((Object)node);
        this.enableFrontLayer();
        this.handleFrontLayerFocus(true);
        Platform.runLater(() -> this.acceleratorService.refresh());
    }

    public void popNode() {
        this.getFrontLayer().ifPresent(this::removeNode);
    }

    private void disableAllLayers() {
        this.content.getChildren().stream().filter(n -> !n.isDisable()).forEach(n -> n.setDisable(true));
        GaussianBlur blur = new GaussianBlur(4.0);
        this.getFrontLayer().ifPresent(frontLayer -> frontLayer.setEffect((Effect)blur));
    }

    private void enableFrontLayer() {
        this.getFrontLayer().ifPresent(frontLayer -> {
            frontLayer.setEffect(null);
            frontLayer.setDisable(false);
        });
    }

    private void handleFrontLayerFocus(boolean restoreFocus) {
        this.getFrontLayer().ifPresent(frontLayer -> {
            Node focused = (Node)frontLayer.getProperties().get((Object)"focused");
            frontLayer.getProperties().remove((Object)"focused");
            if (focused != null && restoreFocus) {
                Platform.runLater(() -> focused.requestFocus());
            }
        });
    }

    private void saveFrontLayerFocus() {
        this.getFrontLayer().ifPresent(frontLayer -> frontLayer.getProperties().put((Object)"focused", (Object)this.focusService.getFocusedNode()));
    }

    public void lockUI() {
        this.lock();
    }

    public void unlockUI() {
        this.unlock();
    }
}

