/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.DialogPane;
import javafx.util.Callback;
import rs.tetrabyte.xcelerate.app.action.ActionBuilder;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;
import rs.tetrabyte.xcelerate.app.context.FocusService;
import rs.tetrabyte.xcelerate.app.control.LockablePane;
import rs.tetrabyte.xcelerate.app.control.SubScreen;
import rs.tetrabyte.xcelerate.app.factory.SubScreenFactory;

public class Screen
extends LockablePane {
    private SubScreenFactory subScreenFactory;
    private Map<String, SubScreen> panes = new HashMap<String, SubScreen>();

    public Screen(SubScreenFactory subScreenFactory, AcceleratorService acceleratorService, FocusService focusService) {
        super(acceleratorService, focusService);
        this.subScreenFactory = subScreenFactory;
        this.getStyleClass().add((Object)"screen");
    }

    public void displayContent(Node content, boolean singleton, boolean closable, List<ActionBuilder> actions, Callback<Void, Void> callback) {
        if (singleton) {
            if (this.panes.get(Integer.toHexString(content.hashCode())) == null) {
                this.panes.put(Integer.toHexString(content.hashCode()), this.subScreenFactory.createSubScreen(content, false, closable, actions));
            }
            this.toFront(this.panes.get(Integer.toHexString(content.hashCode())), callback);
        } else {
            SubScreen pane = this.subScreenFactory.createSubScreen(content, true, closable, actions);
            this.toFront(pane, callback);
        }
    }

    public void removeView(Node view) {
        SubScreen subScreen = null;
        for (Node node : this.getViews()) {
            SubScreen temp = (SubScreen)node;
            if (temp.getCenter() != view) continue;
            subScreen = temp;
        }
        if (subScreen != null) {
            this.removeNode((Node)subScreen);
        }
    }

    public void showDialog(DialogPane dp) {
        SubScreen subScreen = this.subScreenFactory.createSubScreen((Node)dp, false, false, null);
        subScreen.getStyleClass().clear();
        subScreen.getStyleClass().add((Object)"glass-pane");
        this.toFront(subScreen, null);
    }

    public void clear() {
        this.panes = new HashMap<String, SubScreen>();
        this.getChildren().clear();
    }

    private void toFront(final SubScreen pane, final Callback<Void, Void> callback) {
        pane.setOnDeactivate(new EventHandler<Event>(){

            public void handle(Event event) {
                Screen.this.removeNode((Node)pane);
                if (callback != null) {
                    callback.call(null);
                }
            }
        });
        this.addNodeOnTop((Node)pane);
    }
}

