/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.control;

import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import rs.tetrabyte.xcelerate.app.control.Accelerable;
import rs.tetrabyte.xcelerate.app.control.AccelerablePane;
import rs.tetrabyte.xcelerate.app.util.ControlUtil;

public class XButton
extends Button
implements Accelerable {
    private AccelerablePane accelerablePane;
    private String accelerator;

    public XButton() {
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.getStyleClass().add((Object)"xbtn");
        this.accelerablePane = new AccelerablePane(Orientation.VERTICAL, Pos.CENTER);
        this.setGraphic((Node)this.accelerablePane);
        ControlUtil.fireButtonOnEnter((Control)this, this);
    }

    public void setAcceleratorString(String shortcut) {
        this.accelerablePane.setAccelerator(shortcut);
        this.accelerator = shortcut.replaceAll("\\s+", "");
    }

    @Override
    public String getAcceleratorString() {
        return this.accelerator;
    }

    public void setGlyph(String code) {
        this.accelerablePane.setGlyph(code);
    }

    public void setGlyph(Node glyph) {
        this.accelerablePane.setGlyph(glyph);
    }

    public void setButtonText(String text) {
        this.accelerablePane.setText(text);
    }
}

