/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.factory;

import java.io.InputStream;
import java.util.function.Supplier;
import rs.tetrabyte.xcelerate.app.control.Glyph;
import rs.tetrabyte.xcelerate.app.jiconfont.IconFont;
import rs.tetrabyte.xcelerate.app.jiconfont.IconFontFX;

public class GlyphFactory {
    public static void registerGlyphFont(final String name, final Supplier<InputStream> supplier) {
        IconFontFX.register(new IconFont(){

            @Override
            public String getFontFamily() {
                return name;
            }

            @Override
            public InputStream getFontInputStream() {
                return (InputStream)supplier.get();
            }
        });
    }

    public static void registerDefaultGlyphFont(String name, Supplier<InputStream> supplier) {
        GlyphFactory.registerGlyphFont(name, supplier);
    }

    public static Glyph createGlyph() {
        return new Glyph();
    }

    public static Glyph createGlyph(Glyph.Code code) {
        Glyph glyph = GlyphFactory.createGlyph();
        glyph.setGlyphCode(code);
        return glyph;
    }

    public static Glyph createGlyph(String fontFamily, char code) {
        return GlyphFactory.createGlyph(new Glyph.Code(fontFamily, code));
    }

    public static Glyph createGlyph(String string) {
        return GlyphFactory.createGlyph(Glyph.Code.parseGlyphCode(string));
    }

    public static Glyph createGlyph(String code, double size) {
        Glyph glyph = GlyphFactory.createGlyph(code);
        glyph.setIconSize(size);
        return glyph;
    }

    static {
        GlyphFactory.registerDefaultGlyphFont("default", () -> GlyphFactory.class.getResourceAsStream("/rs/tetrabyte/xcelerate/app/fa-solid-900.ttf"));
    }
}

