/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.factory.builder;

import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.util.Builder;
import rs.tetrabyte.xcelerate.app.control.Accelerable;
import rs.tetrabyte.xcelerate.app.control.AccelerablePane;
import rs.tetrabyte.xcelerate.app.control.Glyph;
import rs.tetrabyte.xcelerate.app.factory.GlyphFactory;
import rs.tetrabyte.xcelerate.app.util.AcceleratedLabel;
import rs.tetrabyte.xcelerate.app.util.StringUtils;

public class ButtonBuilder
extends Button
implements Builder<Button>,
Accelerable {
    private AcceleratedLabel accelerated;
    private Glyph glyph = GlyphFactory.createGlyph();

    public Button build() {
        String text = this.getText();
        this.accelerated = AcceleratedLabel.parse(text);
        if (StringUtils.isEmpty(this.accelerated.getAccelerator())) {
            if (!StringUtils.isEmpty(this.accelerated.getGlyphCode())) {
                this.glyph.setGlyphCode(Glyph.Code.parseGlyphCode(this.accelerated.getGlyphCode()));
            }
            this.setGraphic((Node)this.glyph);
            this.setText(this.accelerated.getText());
        } else {
            AccelerablePane accelerablePane = new AccelerablePane(Orientation.VERTICAL, Pos.CENTER);
            if (!StringUtils.isEmpty(this.accelerated.getGlyphCode())) {
                accelerablePane.setGlyph((Node)GlyphFactory.createGlyph(this.accelerated.getGlyphCode()));
            }
            accelerablePane.setAccelerator(this.accelerated.getAccelerator());
            accelerablePane.setText(this.accelerated.getText());
            this.setGraphic((Node)accelerablePane);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
        return this;
    }

    @Override
    public String getAcceleratorString() {
        return this.accelerated.getAccelerator();
    }
}

