/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.jiconfont;

import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;
import rs.tetrabyte.xcelerate.app.jiconfont.DefaultIconCode;
import rs.tetrabyte.xcelerate.app.jiconfont.IconCode;

public class IconCodeConverter
extends StyleConverter<Object, IconCode> {
    public static StyleConverter<Object, IconCode> getInstance() {
        return Holder.INSTANCE;
    }

    private IconCodeConverter() {
    }

    public IconCode convert(ParsedValue<Object, IconCode> value, Font font) {
        Object raw = value.getValue();
        if (raw instanceof String) {
            String valeStr = (String)value.getValue();
            String[] split = valeStr.replace("\"", "").replace("'", "").replaceAll("\\s+", "").split(":");
            if (split.length > 1) {
                char hexVal = this.hex(this.unescape(split[1], '\\'));
                return new DefaultIconCode(split[0], hexVal);
            }
            String val = split[0].replace("\"", "").replace("'", "").trim();
            char hexVal = this.hex(this.unescape(val, '\\'));
            return new DefaultIconCode("default", hexVal);
        }
        throw new IllegalArgumentException("Bad icon code unicode value " + value.getValue().toString());
    }

    private char hex(String hexString) {
        return (char)Integer.parseInt(hexString, 16);
    }

    private String unescape(String val, char chr) {
        if (val.charAt(0) == chr) {
            return val.substring(1);
        }
        return val;
    }

    public String toString() {
        return "IconCodeConverter";
    }

    private static class Holder {
        static final IconCodeConverter INSTANCE = new IconCodeConverter();

        private Holder() {
        }
    }
}

