/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.jiconfont;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import rs.tetrabyte.xcelerate.app.jiconfont.IconCode;
import rs.tetrabyte.xcelerate.app.jiconfont.IconFont;
import rs.tetrabyte.xcelerate.app.jiconfont.IconNode;

public class IconFontFX {
    private static List<IconFont> fonts = new ArrayList<IconFont>();
    private static Map<String, String> aliasMap = new HashMap<String, String>();

    public static synchronized void register(IconFont iconFont) {
        if (!fonts.contains(iconFont)) {
            Font font = Font.loadFont((InputStream)iconFont.getFontInputStream(), (double)0.0);
            fonts.add(iconFont);
            aliasMap.put(iconFont.getFontFamily(), font.getFamily());
        }
    }

    public static Font font(String fontFamily, double size) {
        return Optional.ofNullable(aliasMap.get(fontFamily)).map(f -> new Font(f, size)).orElse(new Font(fontFamily, size));
    }

    public static Image buildImage(IconCode iconCode, Number size, Paint fill) {
        return IconFontFX.buildImage(iconCode, size, fill, null);
    }

    public static Image buildImage(IconCode iconCode, Number size, Paint fill, Paint stroke) {
        IconNode iconNode = new IconNode();
        iconNode.setIconCode(iconCode);
        iconNode.setIconSize(size);
        iconNode.setFill(fill);
        iconNode.setStroke(stroke);
        Group group = new Group(new Node[]{iconNode});
        new Scene((Parent)group);
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        return group.snapshot(parameters, null);
    }
}

