/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.xcelerate.app.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class AcceleratedLabel {
    private static String ACCELERATOR_PATTERN = "(?<t>.*)\\$\\[(?<a>.+?)\\]\\s*(#\\[(?<g>.+?)\\])?";
    private String text;
    private String accelerator;
    private String glyphCode;

    private AcceleratedLabel(String text, String accelerator, String glyphCode) {
        this.text = text;
        this.accelerator = accelerator;
        this.glyphCode = glyphCode;
    }

    public String getText() {
        return this.text;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public String getGlyphCode() {
        return this.glyphCode;
    }

    public static AcceleratedLabel parse(String string) {
        if (StringUtils.isEmpty((Object)string)) {
            return new AcceleratedLabel("", null, null);
        }
        String text = null;
        String accelerator = null;
        String glyph = null;
        Matcher m = Pattern.compile(ACCELERATOR_PATTERN).matcher(string);
        if (m.find()) {
            text = m.group("t").trim();
            accelerator = m.group("a");
            glyph = m.group("g");
        } else {
            text = string.trim();
        }
        return new AcceleratedLabel(text, accelerator, glyph);
    }

    public String toString() {
        return "AcceleratedLabel [text=" + this.text + ", accelerator=" + this.accelerator + ", glyphCode=" + this.glyphCode + "]";
    }

    public static void main(String[] args) {
        System.out.println(AcceleratedLabel.parse("Test 1234 $[F3] #[f060]").toString());
    }
}

