/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos;

import java.io.InputStream;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import rs.tetrabyte.pos.controller.MainViewController;
import rs.tetrabyte.pos.service.KeyboardService;
import rs.tetrabyte.xcelerate.app.XApplication;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLTaskFactory;

@SpringBootApplication
@EnableAutoConfiguration
@ComponentScan(basePackageClasses={PosApplication.class})
public class PosApplication
extends XApplication {
    public static void main(String[] args) {
        PosApplication.launch((String[])args);
    }

    @Override
    public void start(Stage stage) {
        Scene scene = (Scene)this.getApplicationContext().getBean(Scene.class);
        KeyboardService keyboardService = (KeyboardService)this.getApplicationContext().getBean(KeyboardService.class);
        scene.focusOwnerProperty().addListener((o, ov, nv) -> {
            if (nv instanceof TextField) {
                keyboardService.setInputField((TextField)nv);
            }
        });
        stage.setScene(scene);
        scene.getStylesheets().add((Object)"css/nord-dark.css");
        scene.getStylesheets().add((Object)"css/pos.css");
        FXMLTaskFactory fxmlTaskFactory = (FXMLTaskFactory)this.getApplicationContext().getBean(FXMLTaskFactory.class);
        fxmlTaskFactory.createTask(MainViewController.class).execute(v -> {
            stage.show();
            UICommands commands = (UICommands)this.getApplicationContext().getBean(UICommands.class);
            commands.displayContent(v).closable(false).execute();
        });
    }

    @Override
    protected void preInit() {
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/font/Roboto_Condensed-SemiBold.ttf"), (double)12.0);
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/font/JetBrainsMono-SemiBold.ttf"), (double)12.0);
    }
}

