/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.builder.controls;

import java.math.BigDecimal;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.util.Builder;
import rs.tetrabyte.pos.factory.FormatterFactory;
import rs.tetrabyte.xcelerate.app.context.AcceleratorService;

public class FormattedTextField<T>
extends TextField
implements Builder<TextField> {
    private FormatterFactory formatterFactory;
    private AcceleratorService accelerators;
    private ObjectProperty<T> valueProperty = new SimpleObjectProperty();

    public FormattedTextField(FormatterFactory formatterFactory, AcceleratorService accelerators) {
        this.formatterFactory = formatterFactory;
        this.accelerators = accelerators;
    }

    public TextField build() {
        TextFormatter<BigDecimal> formatter = null;
        if ("amount-field".equals(this.getId())) {
            formatter = this.formatterFactory.getAmountTextFormatter();
        } else if ("price-field".equals(this.getId())) {
            formatter = this.formatterFactory.getPriceTextFormatter();
        } else if ("qty-field".equals(this.getId())) {
            formatter = this.formatterFactory.getQtyTextFormatter();
        }
        if (formatter != null) {
            this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
                if (event.getCode() == KeyCode.ESCAPE) {
                    event.consume();
                    this.accelerators.getAccelerator(KeyCombination.valueOf((String)"ESC")).ifPresent(action -> action.run());
                }
            });
            this.setTextFormatter(formatter);
            this.valueProperty.bindBidirectional((Property)formatter.valueProperty());
            this.setAlignment(Pos.BASELINE_RIGHT);
        }
        this.focusedProperty().addListener((o, ov, nv) -> {
            if (nv.booleanValue() && !ov.booleanValue()) {
                Platform.runLater(() -> this.selectAll());
            }
        });
        return this;
    }

    public ObjectProperty<T> valueProperty() {
        return this.valueProperty;
    }

    public T getValue() {
        return (T)this.valueProperty().get();
    }

    public void setValue(T value) {
        this.valueProperty.setValue(value);
    }
}

