/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pos.controller;

import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javax.annotation.PostConstruct;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.pos.controller.CategoryController;
import rs.tetrabyte.pos.model.view.CategoryView;
import rs.tetrabyte.pos.service.CategoryService;
import rs.tetrabyte.xcelerate.app.commands.UICommands;
import rs.tetrabyte.xcelerate.core.fxml.FXMLController;
import rs.tetrabyte.xcelerate.core.fxml.annotation.FXMLView;
import rs.tetrabyte.xcelerate.core.fxml.annotation.Input;
import rs.tetrabyte.xcelerate.core.task.AbstractTask;
import rs.tetrabyte.xcelerate.core.task.TaskFactory;

@FXMLView(value="/fxml/AddCategoryController.fxml")
public class AddCategoryController
extends FXMLController {
    @FXML
    private TextField nameField;
    @FXML
    private ComboBox<FontAwesome.Glyph> iconComboBox;
    @Autowired
    private TaskFactory taskFactory;
    @Autowired
    UICommands commands;
    @Autowired
    private CategoryService categoryService;
    @Input(value="parentCategory")
    private CategoryView parentCategory;
    @Input
    private CategoryController parentController;
    @Input(value="selectedCategory")
    private CategoryView selectedCategory;
    private String iconCode;

    @PostConstruct
    private void init() {
        if (this.selectedCategory != null) {
            this.nameField.setText(this.selectedCategory.getName());
            String code = this.selectedCategory.getIconCode();
            if (code != null && code.contains(":")) {
                code = code.substring(code.indexOf(":") + 1);
            }
            try {
                char iconChar = (char)Integer.parseInt(code, 16);
                for (FontAwesome.Glyph glyph : FontAwesome.Glyph.values()) {
                    if (glyph.getChar() != iconChar) continue;
                    this.iconComboBox.setValue((Object)glyph);
                    break;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Nevalidan iconCode: " + this.selectedCategory.getIconCode());
                e.printStackTrace();
            }
        }
        this.iconComboBox.getItems().addAll((Object[])FontAwesome.Glyph.values());
        this.iconComboBox.setCellFactory(param -> new ListCell<FontAwesome.Glyph>(){

            protected void updateItem(FontAwesome.Glyph glyph, boolean empty) {
                super.updateItem((Object)glyph, empty);
                if (glyph != null && !empty) {
                    this.setGraphic((Node)new Glyph("FontAwesome", (Object)glyph));
                    this.setText(glyph.name());
                } else {
                    this.setGraphic(null);
                    this.setText(null);
                }
            }
        });
        this.iconComboBox.setButtonCell((ListCell)new ListCell<FontAwesome.Glyph>(){

            protected void updateItem(FontAwesome.Glyph glyph, boolean empty) {
                super.updateItem((Object)glyph, empty);
                if (glyph != null && !empty) {
                    this.setGraphic((Node)new Glyph("FontAwesome", (Object)glyph));
                    this.setText(glyph.name());
                } else {
                    this.setGraphic(null);
                    this.setText(null);
                }
            }
        });
        this.iconComboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                this.iconCode = String.format("%04X", newVal.getChar());
                System.out.println("Izabrana ikonica: " + this.iconCode);
            }
        });
    }

    @FXML
    private void onSave() {
        String categoryName;
        if (this.selectedCategory == null) {
            this.selectedCategory = new CategoryView();
            this.selectedCategory.setParent(this.parentCategory);
        }
        if ((categoryName = this.nameField.getText()).isEmpty()) {
            System.out.println("Gre\u0161ka: Naziv kategorije ne mo\u017ee biti prazan!");
            return;
        }
        this.selectedCategory.setName(categoryName);
        this.selectedCategory.setIconCode(this.iconCode);
        ((AbstractTask)((Object)this.taskFactory.createTask(() -> {
            this.categoryService.saveCategory(this.selectedCategory);
            return null;
        }).whenDone(a -> {
            this.commands.removeView((Node)this.getRootNode()).execute();
            this.parentController.refresh();
        }))).execute();
    }

    @FXML
    private void onExit() {
        this.commands.removeView((Node)this.getRootNode()).execute();
    }
}

